import {expect, Locator} from "@playwright/test";

export default class CoralSelectComponent {

  private readonly element: Locator;
  private readonly items: Locator;
  private readonly tagList: Locator;
  private readonly button: Locator;

  constructor(element: Locator) {
    this.element = element;
    this.items = this.element.locator('coral-selectlist-item');
    this.tagList = this.element.locator('coral-taglist > coral-tag');
    this.button = this.element.locator('> button');
  }

  async select(values: Array<string>) {
    const isMultiple = await this.element.getAttribute('multiple');
    for (const val of values) {
      const selectedItem = await this.items.filter({hasText: val}).first();
      await expect(selectedItem).toContainText(val);
      const $selectedItem = await selectedItem.elementHandle();
      await $selectedItem?.evaluate((e) => {
        // Using CoralUI API
        // https://developer.adobe.com/experience-manager/reference-materials/6-5/coral-ui/coralui3/Coral.Select.html
        // @ts-ignore
        e.selected = true;
        // @ts-ignore
        e.trigger('change');
      });
      if (isMultiple === "") {
        const tagsString = await (await this.tagList.locator('coral-tag-label').allTextContents()).join(',');
        expect(tagsString).toEqual(expect.stringContaining(val));
      } else {
        await expect(this.button).toContainText(val);
      }
    }
  }
}