export default class ProjectCreationWizardForm {
  title: string;
  description: string = 'Function Test Description';
  name: string;
  sourceLanguage: string = 'English';
  targetLanguages: Array<string> = [];
  cloudConfiguration: string;
  translationMethod: string = 'Human Translation';
  translationProvider: string = 'XTM Connector'
  automaticallyPromoteTranslationLaunches: boolean = true;
  deleteLaunchAfterPromotion: boolean = true;
  automaticallyApproveTranslation: boolean = true;

  constructor() {
    this.cloudConfiguration = process.env.XTM_CLOUD_CONFIGURATION_PATH;
    const date = this.getFormattedDate();
    this.name = `functional-test-${date}`;
    this.title = `Functional Test ${date}`;
  }

  private getFormattedDate(){
    const now = new Date();
    const yyyy = now.getFullYear();
    let mm = now.getMonth() + 1; // month is zero-based
    let dd = now.getDate();
    let HH = now.getHours();
    let MM = now.getMinutes();
    let SS = now.getSeconds();

    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    if (HH < 10) HH = '0' + HH;
    if (MM < 10) MM = '0' + MM;
    if (SS < 10) SS = '0' + SS;

    return `${yyyy}${mm}${dd}-${HH}${MM}${SS}`;
  }
}