import {defineConfig, devices} from '@playwright/test';
import {AUTH_FILE_AEM} from "./tests/consts";
import * as fs from "fs";

let envFile = (process.env.ENV_FILE) ? `.env.${process.env.ENV_FILE}` : '.env'
if (fs.existsSync('.env.adobe-ci')) {
  envFile = '.env.adobe-ci';
}

require('dotenv').config({path: envFile});

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
  timeout: 180 * 1000,
  expect: {
    timeout: 15_000
  },

  testDir: './tests',
  fullyParallel: true,
  forbidOnly: !!process.env.CI,
  retries: process.env.CI ? 2 : 0,
  workers: process.env.CI ? 1 : undefined,
  reporter: [
    ['list'],
    ['junit', {outputFile: './test-results/junit.xml'}],
    ['html'],
  ],
  use: {
    trace: 'on-first-retry',
    navigationTimeout: 60_000,
  },

  /* Configure projects for major browsers */
  projects: [
    {
      name: 'setup',
      testMatch: /.*\.setup\.ts/
    },
    {
      name: 'beforeall',
      testMatch: 'beforeall.ts',
      use: {
        storageState: AUTH_FILE_AEM,
      },
      dependencies: ['setup'],
    },
    {
      name: 'chromium',
      use: {
        ...devices['Desktop Chrome'],
        // Use prepared auth state.
        storageState: AUTH_FILE_AEM,
      },
      dependencies: ['beforeall'],
    }
  ],
});