import {expect, test as setup} from '@playwright/test';
import {AUTH_FILE_XTM} from "./consts";


setup('Authenticate XTM', async ({page}) => {
  await page.goto(`${process.env.XTM_URL}/saas-manager/login.jsp`);
  await expect(page.locator('.loginPage')).toBeVisible();
  await page.getByLabel('Company name').fill(process.env.XTM_CLIENT);
  await page.getByLabel('Username', { exact: true }).fill(process.env.XTM_USER);
  await page.getByLabel('Password', { exact: true }).fill(process.env.XTM_PASS);
  await page.getByRole('button', {name: 'Log in', exact: true}).click();
  await page.waitForSelector('.mainApp__header');
  await page.context().storageState({path: AUTH_FILE_XTM});
});