import {expect, test as setup} from '@playwright/test';
import {obtainCSRFToken} from "../utils/AemRequestHelper";

const pathsToRemove = [
  '/content/wknd/language-masters/fr',
  '/content/wknd/language-masters/es',
  '/content/wknd/language-masters/it',
  '/content/wknd/language-masters/de',
];

setup('Cleanup test paths', async ({page}) => {
  const request = page.request;
  for (const path of pathsToRemove) {
    const options = {
      headers: {
        'sec-fetch-mode': 'cors',
        'referrerPolicy': 'strict-origin-when-cross-origin',
        'csrf-token': await obtainCSRFToken(page),
        'referer': page.url(),
      }
    };
    const url = `${process.env.AEM_AUTHOR_URL}${path}`;
    const pageResponse = await page.goto(`${url}.json`);
    if (pageResponse.ok()) {
      const apiResponse = await request.delete(url, options);
      expect(apiResponse.status()).toEqual(204);
      expect(apiResponse.ok()).toBeTruthy();
    } else {
      console.info(`${url} does not exists`);
    }
  }
});