import {expect, Page} from "@playwright/test";

export async function obtainCSRFToken(page: Page) {
  const originUrl = page.url();
  const response = await page.goto(`${process.env.AEM_AUTHOR_URL}/libs/granite/csrf/token.json`);
  expect(response.status()).toEqual(200);
  expect(response.ok()).toBeTruthy();
  const json = await response.json();
  expect(json).not.toBeNull();
  expect(json.token).not.toBeUndefined();
  await page.goto(originUrl);
  return json.token;
}

export function formEncodeObject(obj: any) {
  return Object.keys(obj).filter(k => obj.hasOwnProperty(k)).map(
      k => encodeURIComponent(k) + '=' + encodeURIComponent(obj[k])).join('&');
}