/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.raw;

import com.adobe.granite.translation.api.TranslationConstants;
import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.RawTranslationPage;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, adapters={RawTranslationJob.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class RawTranslationJobModel
implements RawTranslationJob {
    @Self
    private Resource translationGadgetResource;
    @ChildResource(name="child_pages")
    private List<RawTranslationPage> pages;
    @ValueMapValue
    private String destinationLanguage;
    @ValueMapValue(name="translationObjectID")
    private String translationObjectId;
    @ValueMapValue(name="translationStatus")
    private String translationStatusRaw;
    private TranslationConstants.TranslationStatus translationStatus;

    @Override
    public String getPath() {
        return this.translationGadgetResource.getPath();
    }

    @Override
    public List<RawTranslationPage> getPages() {
        return this.pages;
    }

    @Override
    public RawTranslationPage getPage(String aemId) {
        return this.pages.stream().filter(page -> StringUtils.equals((CharSequence)page.getTranslationObjectId(), (CharSequence)aemId)).findFirst().orElse(null);
    }

    @Override
    public String getDestinationLanguage() {
        return this.destinationLanguage;
    }

    @Override
    public String getTranslationObjectId() {
        return this.translationObjectId;
    }

    @Override
    public TranslationConstants.TranslationStatus getTranslationStatus() {
        if (this.translationStatus == null) {
            this.translationStatus = TranslationConstants.TranslationStatus.valueOf((String)this.translationStatusRaw);
        }
        return this.translationStatus;
    }
}

