/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.raw;

import com.xtm.aem.api.raw.RawResourceProvider;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.api.raw.RawTranslationProjectManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={ResourceResolver.class}, adapters={RawTranslationProjectManager.class})
public class RawTranslationProjectManagerModel
implements RawTranslationProjectManager {
    private static final Map<String, String> jobIdToProjectPathCache = new HashMap<String, String>();
    @Self
    private ResourceResolver resourceResolver;
    @OSGiService
    private RawResourceProvider rawResourceProvider;

    @Override
    public RawTranslationProject get(String aemTranslationJobId) {
        Resource projectResource;
        String cachedPath = jobIdToProjectPathCache.get(aemTranslationJobId);
        if (StringUtils.isNotBlank((CharSequence)cachedPath) && (projectResource = this.resourceResolver.getResource(cachedPath)) != null) {
            return (RawTranslationProject)Objects.requireNonNull(projectResource.adaptTo(RawTranslationProject.class));
        }
        RawTranslationProject rawProject = this.rawResourceProvider.getTranslationJob(aemTranslationJobId, this.resourceResolver).map(Resource::getParent).map(Resource::getParent).map(Resource::getParent).map(Resource::getParent).map(RawTranslationProject::adapt).orElseThrow(() -> new IllegalArgumentException("Could not find translation job with id '" + aemTranslationJobId + "'"));
        jobIdToProjectPathCache.put(aemTranslationJobId, rawProject.getPath());
        return rawProject;
    }
}

