/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.raw;

import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.RawTranslationProject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, adapters={RawTranslationProject.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class RawTranslationProjectModel
implements RawTranslationProject {
    @Self
    private Resource projectResource;
    @ChildResource(name="jcr:content/dashboard/gadgets")
    private Resource gadgets;
    @ValueMapValue(name="jcr:content/translationProvider")
    private String translationProvider;
    @ValueMapValue(name="jcr:content/active")
    private boolean active;
    @ValueMapValue(name="jcr:content/sourceLanguage")
    private String sourceLanguage;
    @ValueMapValue(name="jcr:content/destinationLanguage")
    private String[] destinationLanguages;
    @ValueMapValue(name="jcr:content/cq:conf")
    private String configFolder;
    private List<RawTranslationJob> translationJobs;

    @Override
    public String getPath() {
        return this.projectResource.getPath();
    }

    @Override
    public String getTranslationProvider() {
        return this.translationProvider;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @Override
    public String[] getDestinationLanguages() {
        return this.destinationLanguages;
    }

    @Override
    public String getConfigFolder() {
        return this.configFolder;
    }

    @Override
    public List<RawTranslationJob> getTranslationJobs() {
        if (this.translationJobs == null) {
            this.translationJobs = StreamSupport.stream(this.gadgets.getChildren().spliterator(), false).filter(r -> r.isResourceType("cq/gui/components/projects/admin/pod/translationjobpod")).map(RawTranslationJob.ADAPT).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.translationJobs;
    }

    @Override
    public RawTranslationJob getTranslationJob(String aemId) {
        return this.getTranslationJobs().stream().filter(atj -> StringUtils.equals((CharSequence)aemId, (CharSequence)atj.getTranslationObjectId())).findFirst().orElse(null);
    }
}

