/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.ui;

import com.adobe.granite.translation.api.TranslationConstants;
import com.google.common.collect.ImmutableMap;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class})
public class SendToTranslationFormDataModel {
    @Self
    private SlingHttpServletRequest request;
    private static final Map<String, Object> BASE_PROJECT_PARAMS = ImmutableMap.of((Object)"isMultiLanguage", (Object)true, (Object)"translationMethod", (Object)TranslationConstants.TranslationMethod.HUMAN_TRANSLATION.name(), (Object)"contentCategory", (Object)"general", (Object)"translationProvider", (Object)"xtm-connector");
    private String projectName;
    private String sourceLanguage;
    private String[] targetLanguages;
    private String configPath;
    private Calendar dueDate;

    @PostConstruct
    protected void postConstruct() {
        this.projectName = this.request.getParameter("xtmProjectName");
        this.sourceLanguage = this.request.getParameter("xtmSourceLanguage");
        this.targetLanguages = this.request.getParameterValues("xtmTargetLanguages");
        String xtmDueDate = this.request.getParameter("xtmDueDate");
        this.dueDate = StringUtils.isEmpty((CharSequence)xtmDueDate) ? null : GregorianCalendar.from(OffsetDateTime.parse(xtmDueDate).toZonedDateTime());
        this.configPath = this.request.getParameter("xtmConfig");
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String[] getTargetLanguages() {
        return Arrays.copyOf(this.targetLanguages, this.targetLanguages.length);
    }

    public Map<String, Object> asPropertyMap() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(BASE_PROJECT_PARAMS);
        parameterMap.put("destinationLanguage", this.targetLanguages);
        parameterMap.put("cq:conf", this.configPath);
        parameterMap.put("sourceLanguage", this.sourceLanguage);
        if (this.dueDate != null) {
            parameterMap.put("project.start", Calendar.getInstance());
            parameterMap.put("project.dueDate", this.dueDate);
        }
        return parameterMap;
    }
}

