/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.xtm;

import com.adobe.granite.translation.api.TranslationConstants;
import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.raw.RawTranslationPage;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.aem.api.xtm.TranslationFile;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, adapters={AemTranslationObject.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class AemTranslationObjectModel
implements AemTranslationObject {
    @Self
    private Resource resource;
    @Self
    private ModifiableValueMap mvm;
    @ValueMapValue
    private String fileName;
    @ValueMapValue
    private String aemTranslationObjectId;
    @ValueMapValue
    private Long xtmJobId;
    @ValueMapValue
    private String translationStatusRaw;
    private TranslationConstants.TranslationStatus translationStatus;
    @ChildResource(name="file.xml")
    private TranslationFile translationFile;
    @ChildResource(name="file.xml")
    private Resource translationFileResource;
    @ChildResource(name="preview.zip")
    private PreviewZipFile previewZipFile;
    @ChildResource(name="translation.xml")
    private Resource translationResultFile;
    private AemTranslationProject project;
    private AemTranslationJob job;
    private RawTranslationPage rawPage;
    private String sourcePath;

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getAemTranslationObjectId() {
        return this.aemTranslationObjectId;
    }

    @Override
    public Long getXtmJobId() {
        return this.xtmJobId;
    }

    @Override
    public void setXtmJobId(Long xtmJobId) throws XtmConnectorException {
        if (this.xtmJobId != null && this.xtmJobId > 0L) {
            throw new XtmConnectorException("Translation object '" + this.aemTranslationObjectId + "' already has an assigned XTM ID");
        }
        this.setXtmJobIdInternal(xtmJobId);
    }

    @Override
    public TranslationConstants.TranslationStatus getTranslationStatus() {
        if (this.translationStatus == null) {
            this.translationStatus = TranslationConstants.TranslationStatus.fromString((String)this.translationStatusRaw);
        }
        return this.translationStatus;
    }

    @Override
    public void setTranslationStatus(TranslationConstants.TranslationStatus newStatus) {
        this.translationStatus = newStatus;
        this.translationStatusRaw = newStatus.toString();
        this.mvm.put((Object)"translationStatusRaw", (Object)this.translationStatusRaw);
    }

    @Override
    public TranslationFile getTranslationFile() {
        return this.translationFile;
    }

    @Override
    public void setTranslationFile(InputStream newTranslationFile) throws PersistenceException {
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        if (this.translationFileResource != null) {
            resourceResolver.delete(this.translationFileResource);
        }
        this.translationFileResource = resourceResolver.create(this.resource, "file.xml", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:file"));
        resourceResolver.create(this.translationFileResource, "jcr:content", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:unstructured", (Object)"jcr:data", (Object)newTranslationFile));
        this.translationFile = (TranslationFile)this.translationFileResource.adaptTo(TranslationFile.class);
        this.setXtmJobIdInternal(0L);
    }

    @Override
    public PreviewZipFile getContentSyncPreview() {
        return this.previewZipFile;
    }

    @Override
    public InputStream getTranslationResult() {
        return this.translationResultFile != null ? (InputStream)this.translationResultFile.adaptTo(InputStream.class) : null;
    }

    @Override
    public void setTranslationResult(InputStream newTranslationResult) throws PersistenceException {
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        if (this.translationResultFile != null) {
            resourceResolver.delete(this.translationResultFile);
        }
        this.translationResultFile = resourceResolver.create(this.resource, "translation.xml", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:file"));
        resourceResolver.create(this.translationResultFile, "jcr:content", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:unstructured", (Object)"jcr:data", (Object)newTranslationResult));
    }

    @Override
    public AemTranslationProject getProject() {
        if (this.project == null) {
            this.project = this.getJob().getProject();
        }
        return this.project;
    }

    @Override
    public AemTranslationJob getJob() {
        if (this.job == null) {
            this.job = (AemTranslationJob)this.resource.getParent().getParent().adaptTo(AemTranslationJob.class);
        }
        return this.job;
    }

    @Override
    public RawTranslationPage getRawPage() {
        if (this.rawPage == null) {
            this.rawPage = this.getJob().getRawJob().getPage(this.aemTranslationObjectId);
        }
        return this.rawPage;
    }

    @Override
    public String getSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = this.getProject().getConfig().getLaunchHandlingStrategy().getSourcePath(this.getRawPage(), this.resource.getResourceResolver());
        }
        return this.sourcePath;
    }

    @Override
    public void setReference(AemTranslationProject project) {
        if (project == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.getJob().getProject().getPath(), (CharSequence)project.getPath())) {
            throw new IllegalArgumentException("Path of the passed project does not match the expected one");
        }
        this.project = project;
    }

    @Override
    public void setReference(AemTranslationJob job) {
        if (job == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.resource.getParent().getParent().getPath(), (CharSequence)job.getPath())) {
            throw new IllegalArgumentException("Path of the passed job does not match the expected one");
        }
        this.job = job;
    }

    @Override
    public void setReference(RawTranslationPage rawPage) {
        if (rawPage == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.aemTranslationObjectId, (CharSequence)rawPage.getTranslationObjectId())) {
            throw new IllegalArgumentException("ID of the passed page does not match the expected one");
        }
        this.rawPage = rawPage;
    }

    private void setXtmJobIdInternal(Long xtmJobId) {
        this.xtmJobId = xtmJobId;
        this.mvm.put((Object)"xtmJobId", (Object)xtmJobId);
    }
}

