/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectFilesApi;
import com.xtm.aem.rest.openapi.model.RSUploadPreviewFileResponse;
import java.io.File;
import java.io.FileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPreviewRestAction
extends BaseXtmRestAction<RSUploadPreviewFileResponse> {
    private static final Logger log = LoggerFactory.getLogger(AddPreviewRestAction.class);
    private final Long projectId;
    private final PreviewZipFile previewFile;

    protected AddPreviewRestAction(Long projectId, PreviewZipFile previewFile, TranslationCloudConfig cloudConfig, RestClientFactory clientFactory, RestTokenStore tokenStore) {
        super(cloudConfig, clientFactory, tokenStore);
        this.projectId = projectId;
        this.previewFile = previewFile;
    }

    @Override
    protected RSUploadPreviewFileResponse runInternal() throws Exception {
        log.trace("AddPreviewAction.run");
        File tempFile = File.createTempFile("preview-", null);
        try (FileOutputStream stream = new FileOutputStream(tempFile);){
            stream.write(this.previewFile.getBytes());
            log.trace("Temp preview file created {}", (Object)tempFile.getPath());
        }
        ProjectFilesApi projectFilesApi = new ProjectFilesApi(this.getApiClient());
        return projectFilesApi.uploadPreviewFileUsingPOST(this.getAccessToken(), this.projectId, tempFile, "preview.zip");
    }
}

