/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseXtmRestAction<T>
implements XtmAction<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseXtmRestAction.class);
    protected final TranslationCloudConfig cloudConfig;
    protected final RestClientFactory clientFactory;
    protected final RestTokenStore tokenStore;

    protected BaseXtmRestAction(TranslationCloudConfig cloudConfig, RestClientFactory clientFactory, RestTokenStore tokenStore) {
        this.cloudConfig = cloudConfig;
        this.clientFactory = clientFactory;
        this.tokenStore = tokenStore;
    }

    @Override
    public final T run() throws TranslationException {
        try {
            return this.runInternal();
        }
        catch (ConnectException | UnknownHostException e) {
            throw new TranslationException("A network error occurred when connecting to XTM", (Throwable)e, TranslationException.ErrorCode.ENGINE_TEMP_UNAVAILABLE);
        }
        catch (ApiException e) {
            throw new TranslationException("An error occurred while communicating with XTM REST API", (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (XtmConnectorException e) {
            throw new TranslationException("An error occurred while communicating with XTM", (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (Exception e) {
            throw new TranslationException("Unspecified error when calling XTM", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    protected abstract T runInternal() throws Exception;

    protected String getAccessToken() {
        return this.tokenStore.getAccessToken(this.cloudConfig);
    }

    protected ApiClient getApiClient() throws ApiException {
        return this.clientFactory.create(this.cloudConfig);
    }
}

