/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectStatesApi;
import com.xtm.aem.rest.openapi.model.RSProjectAnalysisResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAnalysisCompletionAction
extends BaseXtmRestAction<RSProjectAnalysisResponse> {
    protected static final Logger log = LoggerFactory.getLogger(ProjectAnalysisCompletionAction.class);
    private static final int ANALYSIS_CHECK_MAX_RETRIES = 2000;
    private static final int ANALYSIS_CHECK_RETRY_INTERVAL = 2000;
    private final Long projectId;

    protected ProjectAnalysisCompletionAction(Long projectId, TranslationCloudConfig cloudConfig, RestClientFactory clientFactory, RestTokenStore tokenStore) {
        super(cloudConfig, clientFactory, tokenStore);
        this.projectId = projectId;
    }

    @Override
    protected RSProjectAnalysisResponse runInternal() throws Exception {
        ProjectStatesApi projectStatesApi = new ProjectStatesApi(this.getApiClient());
        RSProjectAnalysisResponse response = null;
        for (int i = 0; i < 2000; ++i) {
            response = projectStatesApi.checkProjectAnalysisCompletionUsingGET(this.getAccessToken(), this.projectId, null);
            log.debug("Project [{}], status: {}", (Object)this.projectId, (Object)response.getStatus());
            if (response.getStatus() == RSProjectAnalysisResponse.StatusEnum.FINISHED) {
                return response;
            }
            Thread.sleep(2000L);
        }
        if (response.getStatus() != RSProjectAnalysisResponse.StatusEnum.FINISHED) {
            throw new XtmConnectorException("Maximum number of retries exceeded while checking for analysis completion in XTM");
        }
        return response;
    }
}

