/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.actions.XtmRestActionsUtil;
import com.xtm.aem.rest.openapi.api.ProjectFilesApi;
import com.xtm.aem.rest.openapi.model.RSProjectFileUploadResponse;
import com.xtm.aem.rest.overrides.ProjectFilesApiMatchType;
import com.xtm.aem.rest.overrides.YesNoType;
import com.xtm.aem.rest.overrides.model.ProjectTranslationFile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTranslationFileToProjectRestAction
extends BaseXtmRestAction<RSProjectFileUploadResponse> {
    private static final Logger log = LoggerFactory.getLogger(UploadTranslationFileToProjectRestAction.class);
    private final Long xtmProjectId;
    private final List<AemTranslationObject> translationObjects;
    private final ProjectFilesApiMatchType matchingType;

    public UploadTranslationFileToProjectRestAction(Long xtmProjectId, List<AemTranslationObject> translationObjects, TranslationCloudConfig cloudConfig, ProjectFilesApiMatchType matchingType, RestClientFactory clientFactory, RestTokenStore tokenStore) {
        super(cloudConfig, clientFactory, tokenStore);
        this.translationObjects = translationObjects;
        this.xtmProjectId = xtmProjectId;
        this.matchingType = matchingType;
    }

    @Override
    protected RSProjectFileUploadResponse runInternal() throws Exception {
        log.trace("UploadTranslationFileToProjectRestAction.runInternal");
        List<ProjectTranslationFile> translationFiles = XtmRestActionsUtil.prepareTranslationFiles(this.translationObjects);
        ProjectFilesApi projectFilesApi = new ProjectFilesApi(this.getApiClient());
        return projectFilesApi.uploadSourceFilesUsingPOST(this.getAccessToken(), this.xtmProjectId, translationFiles, this.matchingType, YesNoType.NO);
    }
}

