/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.rest.actions.AddPreviewRestAction;
import com.xtm.aem.rest.actions.CreateProjectRestAction;
import com.xtm.aem.rest.actions.ProjectAnalysisCompletionAction;
import com.xtm.aem.rest.actions.UpdateProjectTargetLanguageRestAction;
import com.xtm.aem.rest.actions.UploadTranslationFileToProjectRestAction;
import com.xtm.aem.rest.openapi.model.RSProjectAnalysisResponse;
import com.xtm.aem.rest.openapi.model.RSProjectCreationResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileUploadResponse;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesAddResponse;
import com.xtm.aem.rest.openapi.model.RSUploadPreviewFileResponse;
import com.xtm.aem.rest.overrides.ProjectFilesApiMatchType;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmRestActionFactory
implements RestActionFactory {
    @Reference
    private RestTokenStore tokenStore;
    @Reference
    private RestClientFactory clientFactory;

    @Override
    public XtmAction<RSProjectTargetLanguagesAddResponse> getUpdateProjectTargetLanguageAction(Long projectId, List<String> languagesToAdd, TranslationCloudConfig config) {
        return new UpdateProjectTargetLanguageRestAction(projectId, languagesToAdd, config, this.clientFactory, this.tokenStore);
    }

    @Override
    public XtmAction<RSUploadPreviewFileResponse> getAddPreviewAction(Long projectId, PreviewZipFile previewFile, TranslationCloudConfig config) {
        return new AddPreviewRestAction(projectId, previewFile, config, this.clientFactory, this.tokenStore);
    }

    @Override
    public XtmAction<RSProjectAnalysisResponse> getProjectAnalysisCompletionAction(Long projectId, TranslationCloudConfig config) {
        return new ProjectAnalysisCompletionAction(projectId, config, this.clientFactory, this.tokenStore);
    }

    @Override
    public XtmAction<RSProjectCreationResponse> getCreateProjectAction(AemTranslationJob atj) {
        return new CreateProjectRestAction(atj, atj.getProject().getConfig(), this.clientFactory, this.tokenStore, this);
    }

    @Override
    public XtmAction<RSProjectFileUploadResponse> getUploadTranslationFileToProjectAction(Long xtmProjectId, List<AemTranslationObject> aemTranslationObjects, ProjectFilesApiMatchType matchType, TranslationCloudConfig cloudConfig) {
        return new UploadTranslationFileToProjectRestAction(xtmProjectId, aemTranslationObjects, cloudConfig, matchType, this.clientFactory, this.tokenStore);
    }
}

