/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.rest.overrides.model.ProjectTranslationFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XtmRestActionsUtil {
    private static final Logger log = LoggerFactory.getLogger(XtmRestActionsUtil.class);

    private XtmRestActionsUtil() {
        throw new IllegalStateException("Not instantiable");
    }

    public static List<ProjectTranslationFile> prepareTranslationFiles(Collection<AemTranslationObject> aemTranslationObjects) {
        return aemTranslationObjects.stream().map(XtmRestActionsUtil::toFile).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static ProjectTranslationFile toFile(AemTranslationObject translationObject) {
        try {
            File file = File.createTempFile("translation-object-", null);
            try (FileOutputStream fileStream = new FileOutputStream(file);){
                fileStream.write(translationObject.getTranslationFile().getBytes());
            }
            String aemLang = translationObject.getJob().getTargetLanguage();
            String xtmLang = translationObject.getProject().getConfig().getLanguageMapping().get(aemLang);
            List<String> targetLanguages = Collections.singletonList(xtmLang);
            return new ProjectTranslationFile(file, null, null, translationObject.getFileName(), null, targetLanguages, null, null, null);
        }
        catch (IOException e) {
            log.warn("Failed to write translation file '{}'", (Object)translationObject.getFileName(), (Object)e);
            return null;
        }
    }
}

