/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class OauthAccessTokenResponse
implements OauthAccessTokenModel {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    public static final String JSON_PROPERTY_SCOPE = "scope";
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="scope")
    private String scope;

    public OauthAccessTokenResponse(Map<String, String> map) {
        this.accessToken = map.get(JSON_PROPERTY_ACCESS_TOKEN);
        this.refreshToken = map.get(JSON_PROPERTY_REFRESH_TOKEN);
        this.expiresIn = new Long(map.get(JSON_PROPERTY_EXPIRES_IN));
        this.tokenType = map.get(JSON_PROPERTY_TOKEN_TYPE);
        this.scope = map.get(JSON_PROPERTY_SCOPE);
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn, this.scope);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthAccessTokenResponse other = (OauthAccessTokenResponse)o;
        return Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.tokenType, other.tokenType) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.expiresIn, other.expiresIn) && Objects.equals(this.scope, other.scope);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)"class OAuthAccessTokenResponse {\n").append((Object)("    accessToken: " + this.accessToken + "\n")).append((Object)("    refreshToken: " + this.refreshToken + "\n")).append((Object)("    expiresIn: " + this.expiresIn + "\n")).append((Object)("    tokenType: " + this.tokenType + "\n")).append((Object)("    scope: " + this.scope + "\n")).append((Object)"}").toString();
    }
}

