/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import com.xtm.aem.rest.client.OauthAccessTokenResponse;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Pair;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class OauthApi {
    private static final String API_PATH = "/oauth/token";
    private static final String GRANT_TYPE_GET_TOKEN = "password";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final TypeReference<Map<String, String>> RETURN_TYPE = new TypeReference<Map<String, String>>(){};
    private final ApiClient apiClient;

    public OauthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OauthAccessTokenModel getAccessToken(String oAuthClientId, String oAuthClientSecret, String clientName, long userId, String password) throws ApiException {
        this.apiClient.setServerIndex(1);
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("grant_type", GRANT_TYPE_GET_TOKEN);
        formParams.put("user_id", OauthApi.getUserIdParam(clientName, userId));
        formParams.put(GRANT_TYPE_GET_TOKEN, password);
        String[] localVarAuthNames = new String[]{"Roles"};
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        Map<String, String> map = this.apiClient.invokeAPI(API_PATH, "POST", new ArrayList<Pair>(), new ArrayList<Pair>(), null, OauthApi.getHeaders(OauthApi.encodeOauthCredentials(oAuthClientId, oAuthClientSecret)), new HashMap<String, String>(), formParams, localVarAccept, localVarContentType, localVarAuthNames, RETURN_TYPE);
        return new OauthAccessTokenResponse(map);
    }

    public OauthAccessTokenModel refreshAccessToken(String oAuthClientId, String oAuthClientSecret, String refreshToken) throws ApiException {
        this.apiClient.setServerIndex(1);
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("grant_type", GRANT_TYPE_REFRESH_TOKEN);
        formParams.put(GRANT_TYPE_REFRESH_TOKEN, refreshToken);
        String[] localVarAuthNames = new String[]{"Roles"};
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        Map<String, String> map = this.apiClient.invokeAPI(API_PATH, "POST", new ArrayList<Pair>(), new ArrayList<Pair>(), null, OauthApi.getHeaders(OauthApi.encodeOauthCredentials(oAuthClientId, oAuthClientSecret)), new HashMap<String, String>(), formParams, localVarAccept, localVarContentType, localVarAuthNames, RETURN_TYPE);
        return new OauthAccessTokenResponse(map);
    }

    private static String getUserIdParam(String clientName, long userId) {
        return clientName + ":" + userId;
    }

    private static String encodeOauthCredentials(String oAuthClientId, String oAuthClientSecret) {
        String toEncode = oAuthClientId + ":" + oAuthClientSecret;
        return Base64.getEncoder().encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
    }

    private static Map<String, String> getHeaders(String authorization) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + authorization);
        return headers;
    }
}

