/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSExternalUserCreateRequest;
import com.xtm.aem.rest.openapi.model.RSExternalUserCreateResponse;
import com.xtm.aem.rest.openapi.model.RSExternalUserDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSExternalUserGetResponse;
import com.xtm.aem.rest.openapi.model.RSExternalUserPatchRequest;
import com.xtm.aem.rest.openapi.model.RSExternalUserPatchResponse;
import com.xtm.aem.rest.openapi.model.RSExternalUserPutRequest;
import com.xtm.aem.rest.openapi.model.RSExternalUserPutResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExternalUsersApi {
    private ApiClient apiClient;

    public ExternalUsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExternalUsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSExternalUserCreateResponse createExternalUserUsingPOST(String authorization, RSExternalUserCreateRequest request) throws ApiException {
        RSExternalUserCreateRequest localVarPostBody = request;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling createExternalUserUsingPOST");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling createExternalUserUsingPOST");
        }
        String localVarPath = "/externals/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSExternalUserCreateResponse> localVarReturnType = new TypeReference<RSExternalUserCreateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSExternalUserDeleteResponse deleteExternalUserUsingDELETE(String authorization, Long externalUserId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deleteExternalUserUsingDELETE");
        }
        if (externalUserId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalUserId' when calling deleteExternalUserUsingDELETE");
        }
        String localVarPath = "/externals/users/{externalUserId}".replaceAll("\\{externalUserId\\}", this.apiClient.escapeString(externalUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSExternalUserDeleteResponse> localVarReturnType = new TypeReference<RSExternalUserDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSExternalUserGetResponse> findExternalUsersUsingGET(String authorization, List<String> emails, List<String> firstNames, List<Long> ids, List<String> integrationIds, List<String> lastNames, List<String> usernames) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findExternalUsersUsingGET");
        }
        String localVarPath = "/externals/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "emails", emails));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "firstNames", firstNames));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "integrationIds", integrationIds));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "lastNames", lastNames));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "usernames", usernames));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSExternalUserGetResponse>> localVarReturnType = new TypeReference<List<RSExternalUserGetResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSExternalUserGetResponse getExternalUserUsingGET(String authorization, Long externalUserId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getExternalUserUsingGET");
        }
        if (externalUserId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalUserId' when calling getExternalUserUsingGET");
        }
        String localVarPath = "/externals/users/{externalUserId}".replaceAll("\\{externalUserId\\}", this.apiClient.escapeString(externalUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSExternalUserGetResponse> localVarReturnType = new TypeReference<RSExternalUserGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSExternalUserPatchResponse patchExternalUserUsingPATCH(String authorization, Long externalUserId, RSExternalUserPatchRequest externalUserPatchRequest) throws ApiException {
        RSExternalUserPatchRequest localVarPostBody = externalUserPatchRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchExternalUserUsingPATCH");
        }
        if (externalUserId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalUserId' when calling patchExternalUserUsingPATCH");
        }
        if (externalUserPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'externalUserPatchRequest' when calling patchExternalUserUsingPATCH");
        }
        String localVarPath = "/externals/users/{externalUserId}".replaceAll("\\{externalUserId\\}", this.apiClient.escapeString(externalUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSExternalUserPatchResponse> localVarReturnType = new TypeReference<RSExternalUserPatchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSExternalUserPutResponse putExternalUserUsingPUT(String authorization, Long externalUserId, RSExternalUserPutRequest externalUserPutRequest) throws ApiException {
        RSExternalUserPutRequest localVarPostBody = externalUserPutRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling putExternalUserUsingPUT");
        }
        if (externalUserId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalUserId' when calling putExternalUserUsingPUT");
        }
        if (externalUserPutRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'externalUserPutRequest' when calling putExternalUserUsingPUT");
        }
        String localVarPath = "/externals/users/{externalUserId}".replaceAll("\\{externalUserId\\}", this.apiClient.escapeString(externalUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSExternalUserPutResponse> localVarReturnType = new TypeReference<RSExternalUserPutResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

