/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.ProjectStatistics;
import com.xtm.aem.rest.openapi.model.RSAggregatedStatisticsResponse;
import com.xtm.aem.rest.openapi.model.RSGenerateStatisticsResponse;
import com.xtm.aem.rest.openapi.model.RSJobMetricsResponse;
import com.xtm.aem.rest.openapi.model.RSLanguageMetricsResponse;
import com.xtm.aem.rest.openapi.model.RSMetricsFilesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProjectAnalyticsApi {
    private ApiClient apiClient;

    public ProjectAnalyticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectAnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void downloadProjectMetricsFileUsingGET(String authorization, Long fileId, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadProjectMetricsFileUsingGET");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling downloadProjectMetricsFileUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling downloadProjectMetricsFileUsingGET");
        }
        String localVarPath = "/projects/{projectId}/metrics/files/{fileId}/download".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void downloadProjectMetricsFilesUsingGET(String authorization, String metricsFilesType, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadProjectMetricsFilesUsingGET");
        }
        if (metricsFilesType == null) {
            throw new ApiException(400, "Missing the required parameter 'metricsFilesType' when calling downloadProjectMetricsFilesUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling downloadProjectMetricsFilesUsingGET");
        }
        String localVarPath = "/projects/{projectId}/metrics/files/download".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("metricsFilesType", metricsFilesType));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public RSAggregatedStatisticsResponse downloadStatisticsUsingGET(String authorization, String processId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadStatisticsUsingGET");
        }
        if (processId == null) {
            throw new ApiException(400, "Missing the required parameter 'processId' when calling downloadStatisticsUsingGET");
        }
        String localVarPath = "/projects/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processId", processId));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSAggregatedStatisticsResponse> localVarReturnType = new TypeReference<RSAggregatedStatisticsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSJobMetricsResponse> findJobsMetricsUsingGET(String authorization, List<Long> jobIds, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findJobsMetricsUsingGET");
        }
        if (jobIds == null) {
            throw new ApiException(400, "Missing the required parameter 'jobIds' when calling findJobsMetricsUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling findJobsMetricsUsingGET");
        }
        String localVarPath = "/projects/{projectId}/metrics/jobs".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSJobMetricsResponse>> localVarReturnType = new TypeReference<List<RSJobMetricsResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSMetricsFilesResponse> findProjectMetricsFilesUsingGET(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findProjectMetricsFilesUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling findProjectMetricsFilesUsingGET");
        }
        String localVarPath = "/projects/{projectId}/metrics/files".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSMetricsFilesResponse>> localVarReturnType = new TypeReference<List<RSMetricsFilesResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSLanguageMetricsResponse> findProjectMetricsUsingGET(String authorization, Long projectId, List<String> targetLanguages) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findProjectMetricsUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling findProjectMetricsUsingGET");
        }
        String localVarPath = "/projects/{projectId}/metrics".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSLanguageMetricsResponse>> localVarReturnType = new TypeReference<List<RSLanguageMetricsResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ProjectStatistics> findProjectStatisticsUsingGET(String authorization, Long projectId, String fetchType, List<String> targetLanguages) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findProjectStatisticsUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling findProjectStatisticsUsingGET");
        }
        String localVarPath = "/projects/{projectId}/statistics".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fetchType", fetchType));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<ProjectStatistics>> localVarReturnType = new TypeReference<List<ProjectStatistics>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSGenerateStatisticsResponse generateStatisticsUsingPOST(String authorization, String endDate, List<Long> linguistIds, List<Long> projectIds, String reportType, String startDate) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling generateStatisticsUsingPOST");
        }
        String localVarPath = "/projects/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "linguistIds", linguistIds));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "projectIds", projectIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("reportType", reportType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSGenerateStatisticsResponse> localVarReturnType = new TypeReference<RSGenerateStatisticsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

