/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSEditorLinkRequest;
import com.xtm.aem.rest.openapi.model.RSEditorLinkResponse;
import com.xtm.aem.rest.openapi.model.RSProjectEditorLinkRequest;
import com.xtm.aem.rest.openapi.model.RSProjectEditorLinkResponse;
import java.util.ArrayList;
import java.util.HashMap;

public class ProjectLinksApi {
    private ApiClient apiClient;

    public ProjectLinksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSEditorLinkResponse generateEditorLinkUsingPOST(String authorization, Long projectId, RSEditorLinkRequest editorLinkRequest) throws ApiException {
        RSEditorLinkRequest localVarPostBody = editorLinkRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling generateEditorLinkUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling generateEditorLinkUsingPOST");
        }
        if (editorLinkRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'editorLinkRequest' when calling generateEditorLinkUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/links/editor".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSEditorLinkResponse> localVarReturnType = new TypeReference<RSEditorLinkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectEditorLinkResponse generateProjectEditorLinkUsingPOST(String authorization, Long projectId, RSProjectEditorLinkRequest projectEditorLinkRequest) throws ApiException {
        RSProjectEditorLinkRequest localVarPostBody = projectEditorLinkRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling generateProjectEditorLinkUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling generateProjectEditorLinkUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/links/project-editor".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectEditorLinkResponse> localVarReturnType = new TypeReference<RSProjectEditorLinkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

