/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.rest.OauthClientDataProvider;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(property={"service.description=Settings for the XTM REST API connection", "label=XTM OAuth Client Data Provider"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
@Designate(ocd=Configuration.class)
public class XtmOauthClientDataProvider
implements OauthClientDataProvider {
    static final String DEFAULT_CLIENT_ID = "AEM6";
    static final String DEFAULT_CLIENT_SECRET = "db1aed9daba14a0891436bd3af4e0837";
    private String clientId;
    private String clientSecret;

    @Activate
    public void activate(Configuration configuration) {
        this.clientId = (String)StringUtils.defaultIfBlank((CharSequence)configuration.client_id(), (CharSequence)DEFAULT_CLIENT_ID);
        this.clientSecret = (String)StringUtils.defaultIfBlank((CharSequence)configuration.client_secret(), (CharSequence)DEFAULT_CLIENT_SECRET);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @ObjectClassDefinition(name="XTM OAuth Client Data Provider", description="Stores data required by the REST API connection")
    public static @interface Configuration {
        @AttributeDefinition(name="Client ID", description="OAuth 2.0 Client ID", defaultValue={"AEM6"})
        public String client_id();

        @AttributeDefinition(name="Client Secret", description="OAuth 2.0 Client Secret", defaultValue={"db1aed9daba14a0891436bd3af4e0837"})
        public String client_secret();
    }
}

