/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.api.SystemApi;
import com.xtm.aem.rest.openapi.model.RSSystemInfoResponse;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=XTM Intl", "sling.servlet.methods=GET", "sling.servlet.paths=/services/xtm/rest-connection-test"})
public class XtmRestConnectionTesterServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(XtmRestConnectionTesterServlet.class);
    @Reference
    private RestClientFactory restClientFactory;
    @Reference
    private RestTokenStore tokenStore;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String xtmConfPath = request.getParameter("xtmConfPath");
        if (StringUtils.isBlank((CharSequence)xtmConfPath)) {
            XtmRestConnectionTesterServlet.write(response, "Please specify xtmConfPath query parameter that points to a valid XTM configuration");
            return;
        }
        TranslationCloudConfig cc = XtmRestConnectionTesterServlet.getTranslationCloudConfig(request, xtmConfPath);
        if (cc == null) {
            XtmRestConnectionTesterServlet.write(response, "Failed to obtain XTM Translation Cloud Configuration for defined path: " + xtmConfPath);
            return;
        }
        try {
            ApiClient apiClient = this.restClientFactory.create(cc);
            SystemApi systemApi = new SystemApi(apiClient);
            XtmRestConnectionTesterServlet.write(response, "Connecting to XTM system information endpoint... \r\n");
            String accessToken = this.tokenStore.getAccessToken(cc);
            RSSystemInfoResponse result = systemApi.getXTMInfoUsingGET(accessToken);
            log.info(result.toString());
            XtmRestConnectionTesterServlet.write(response, result.toString());
            XtmRestConnectionTesterServlet.write(response, "\r\nConnection successful!");
        }
        catch (ApiException e) {
            log.error("FAIL", (Throwable)e);
            XtmRestConnectionTesterServlet.write(response, "Something went wrong");
            XtmRestConnectionTesterServlet.write(response, e.getResponseBody());
        }
    }

    private static TranslationCloudConfig getTranslationCloudConfig(SlingHttpServletRequest request, String xtmConfPath) {
        return Optional.of(request).map(SlingHttpServletRequest::getResourceResolver).map(resourceResolver -> resourceResolver.getResource(xtmConfPath)).map(r -> (TranslationCloudConfig)r.adaptTo(TranslationCloudConfig.class)).orElse(null);
    }

    private static void write(SlingHttpServletResponse response, String msg) throws IOException {
        response.getWriter().write(msg + "\r\n");
    }
}

