/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.TranslationCloudConfigFinder;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import com.xtm.aem.api.rest.OauthClientDataProvider;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.rest.client.OauthApi;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")}, immediate=true)
@Designate(ocd=Configuration.class)
public class XtmRestTokenRefreshScheduledJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(XtmRestTokenRefreshScheduledJob.class);
    static final String SCHEDULER_JOB_TOPIC = "xtm-rest-token-refresh";
    static final String DEFAULT_CRON_EXPRESSION = "0 0 6 ? * * *";
    @Reference
    private Scheduler scheduler;
    @Reference
    private RestClientFactory clientFactory;
    @Reference
    private RestTokenStore tokenStore;
    @Reference
    private TranslationCloudConfigFinder translationCloudConfigFinder;
    @Reference
    private ResourceResolverProvider resourceResolverProvider;
    @Reference
    private OauthClientDataProvider clientDataProvider;
    private String cronExpression;

    @Activate
    public void activate(Configuration configuration) {
        this.cronExpression = (String)StringUtils.defaultIfBlank((CharSequence)configuration.cron_expression(), (CharSequence)DEFAULT_CRON_EXPRESSION);
        this.removeScheduler();
        this.startScheduledJob();
        this.runJobOnComponentActivation();
    }

    @Override
    public void run() {
        try (ResourceResolver resourceResolver = this.resourceResolverProvider.getXtmResourceResolver();){
            for (TranslationCloudConfig translationCloudConfig : this.translationCloudConfigFinder.getConfigs(resourceResolver)) {
                log.debug("Processing {}", (Object)translationCloudConfig.getPath());
                if (this.validateCloudConfiguration(translationCloudConfig)) {
                    this.processCloudConfiguration(translationCloudConfig);
                    continue;
                }
                log.warn("Invalid translation cloud configuration: {}", (Object)translationCloudConfig.getPath());
            }
        }
        catch (LoginException e) {
            log.error("Failed to obtain XTMConfig Resource Resolver", (Throwable)e);
        }
    }

    private boolean validateCloudConfiguration(TranslationCloudConfig cc) {
        return cc != null && StringUtils.isNotBlank((CharSequence)cc.getWebserviceUri()) && StringUtils.isNotBlank((CharSequence)cc.getClient()) && ObjectUtils.isNotEmpty((Object)cc.getUserId()) && StringUtils.isNotBlank((CharSequence)cc.getPassword());
    }

    private void processCloudConfiguration(TranslationCloudConfig cloudConf) {
        try {
            OauthAccessTokenModel tokenModel;
            ApiClient apiClient = this.clientFactory.create(cloudConf);
            OauthApi oAuthApi = new OauthApi(apiClient);
            String refreshToken = Optional.ofNullable(this.tokenStore.getTokenResponse(cloudConf)).map(OauthAccessTokenModel::getRefreshToken).orElse(null);
            if (refreshToken == null) {
                tokenModel = oAuthApi.getAccessToken(this.clientDataProvider.getClientId(), this.clientDataProvider.getClientSecret(), cloudConf.getClient(), cloudConf.getUserId(), cloudConf.getPassword());
                log.debug("Getting Token XTM REST Token for {}", (Object)cloudConf.getPath());
            } else {
                tokenModel = oAuthApi.refreshAccessToken(this.clientDataProvider.getClientId(), this.clientDataProvider.getClientSecret(), refreshToken);
                log.debug("Refreshing Token XTM REST Token for {}", (Object)cloudConf.getPath());
            }
            this.tokenStore.addToken(cloudConf, tokenModel);
            log.debug("XTM REST Token has been refreshed: {}", (Object)tokenModel);
        }
        catch (ApiException e) {
            log.error("API Exception while processing: '{}'. Please check translation cloud configuration.", (Object)cloudConf.getPath(), (Object)e);
        }
    }

    private void removeScheduler() {
        log.trace("Unschedule all jobs: {}", (Object)SCHEDULER_JOB_TOPIC);
        this.scheduler.unschedule(SCHEDULER_JOB_TOPIC);
    }

    private void startScheduledJob() {
        ScheduleOptions options = this.scheduler.EXPR(this.cronExpression).canRunConcurrently(false).name(SCHEDULER_JOB_TOPIC);
        this.scheduler.schedule((Object)this, options);
    }

    private void runJobOnComponentActivation() {
        log.info("XTM REST API Token Refresh Job run on component activation");
        this.run();
    }

    @ObjectClassDefinition(name="XTM REST Token Refresh Scheduler", description="Defines when automated token refresh occurs")
    public static @interface Configuration {
        @AttributeDefinition(name="CRON Expression", description="Valid Quartz CRON expression i.e. '0 * * ? * *' - will fire every minute. By default REST tokens are refreshed every morning at 6:00 AM", defaultValue={"0 0 6 ? * * *"})
        public String cron_expression();
    }
}

