/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services.postprocessors;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import com.xtm.aem.api.rest.OauthClientDataProvider;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.rest.client.OauthApi;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmCredentialsPostProcessor
implements SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(XtmCredentialsPostProcessor.class);
    @Reference
    private RestClientFactory clientFactory;
    @Reference
    private OauthClientDataProvider clientDataProvider;
    @Reference
    private RestTokenStore tokenStore;

    public void process(SlingHttpServletRequest request, List<Modification> list) {
        if (!XtmCredentialsPostProcessor.canProcess(request)) {
            return;
        }
        TranslationCloudConfig cloudConf = (TranslationCloudConfig)request.getResource().getParent().adaptTo(TranslationCloudConfig.class);
        if (!XtmCredentialsPostProcessor.isValidCloudConfiguration(cloudConf)) {
            log.warn("Invalid Translation Cloud Configuration provided");
            return;
        }
        try {
            ApiClient apiClient = this.clientFactory.create(cloudConf);
            OauthApi oAuthApi = new OauthApi(apiClient);
            OauthAccessTokenModel accessToken = oAuthApi.getAccessToken(this.clientDataProvider.getClientId(), this.clientDataProvider.getClientSecret(), cloudConf.getClient(), cloudConf.getUserId(), cloudConf.getPassword());
            this.tokenStore.addToken(cloudConf, accessToken);
        }
        catch (ApiException e) {
            log.error("Failed to obtain API REST Token", (Throwable)e);
        }
    }

    private static boolean canProcess(SlingHttpServletRequest request) {
        return request.getRequestPathInfo().getResourcePath().startsWith("/conf") && request.getResource().getResourceType().equals("cq/translation/components/mt-cloudconfig");
    }

    private static boolean isValidCloudConfiguration(TranslationCloudConfig cloudConfig) {
        return cloudConfig != null && StringUtils.isNotBlank((CharSequence)cloudConfig.getWebserviceUri()) && StringUtils.isNotBlank((CharSequence)cloudConfig.getClient()) && cloudConfig.getUserId() != null && StringUtils.isNotBlank((CharSequence)cloudConfig.getPassword());
    }
}

