/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.raw;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.raw.RawResourceProvider;
import java.util.Iterator;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class RawResourceProviderService
implements RawResourceProvider {
    private static final String FIND_TRANSLATION_JOB_BY_ID = "SELECT * FROM [nt:base] AS r WHERE ISDESCENDANTNODE([/content/projects]) AND r.[translationObjectID] = '%s'";

    @Override
    public Optional<Resource> getTranslationJob(String aemTranslationJobId, ResourceResolver resourceResolver) throws IllegalStateException {
        String query = String.format(FIND_TRANSLATION_JOB_BY_ID, aemTranslationJobId);
        Iterator foundTranslationJobs = resourceResolver.findResources(query, "JCR-SQL2");
        if (!foundTranslationJobs.hasNext()) {
            return Optional.empty();
        }
        Resource translationJobResource = (Resource)foundTranslationJobs.next();
        if (foundTranslationJobs.hasNext()) {
            throw new IllegalStateException("Found multiple translation jobs with id '" + aemTranslationJobId + "'");
        }
        return Optional.of(translationJobResource);
    }
}

