/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation;

import com.adobe.granite.translation.api.TranslationMetadata;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationState;
import java.util.Arrays;
import java.util.stream.Collectors;

public class LogUtils {
    private LogUtils() {
        throw new IllegalStateException("Not instantiable");
    }

    public static String toLogString(TranslationObject translationObject) {
        return "\"" + translationObject.getId() + "\":\"" + LogUtils.toLogString(translationObject.getTranslationJobMetadata()) + "\"";
    }

    public static String toLogString(TranslationObject[] translationObjects) {
        return Arrays.stream(translationObjects).map(LogUtils::toLogString).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String toLogString(TranslationState translationState) {
        return "\"" + translationState.toString() + "\"";
    }

    public static String toLogString(TranslationState[] translationStates) {
        return Arrays.stream(translationStates).map(LogUtils::toLogString).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String toLogString(TranslationMetadata translationMetadata) {
        return translationMetadata.getTranslationState().toString();
    }
}

