/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation;

import com.adobe.granite.translation.api.TranslationException;
import com.google.common.collect.ImmutableList;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.aem.soap.api.ActionFactory;
import com.xtm.aem.soap.wsdl.LanguageCODE;
import com.xtm.aem.soap.wsdl.XtmJobStatusResponseAPI;
import com.xtm.aem.soap.wsdl.XtmPROJECTACTIVITY;
import com.xtm.aem.soap.wsdl.XtmProjectStatusResponseAPI;
import com.xtm.translation.connector.xtmforaem.core.impl.TranslationController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmCancellerService
implements XtmCanceller {
    private static final Logger log = LoggerFactory.getLogger(XtmCancellerService.class);
    @Reference
    private ActionFactory actionFactory;

    @Override
    public void cancel(AemTranslationProject project) throws TranslationException {
        log.info("Cancelling project '{}'", (Object)project.getPath());
        this.cancelProjects(Arrays.asList(project.getXtmProjectIds()), project.getConfig());
    }

    @Override
    public void cancel(AemTranslationJob job) throws TranslationException {
        log.info("Cancelling job '{}'", (Object)job.getAemJobId());
        AemTranslationProject project = job.getProject();
        TranslationCloudConfig config = project.getConfig();
        Long xtmProjectId = job.getXtmProjectId();
        if (this.isOnlyAemJobWithinXtmProject(job, project)) {
            this.cancelProject(xtmProjectId, config);
        }
        List<Long> xtmJobIdsToDelete = job.getAemTranslationObjects().stream().map(AemTranslationObject::getXtmJobId).collect(Collectors.toList());
        LanguageCODE targetLanguage = TranslationController.getTargetLanguageCode(job);
        this.deleteJobsFromXtmProject(config, xtmProjectId, xtmJobIdsToDelete, targetLanguage);
    }

    @Override
    public void cancel(AemTranslationObject translationObject) throws TranslationException {
        log.info("Cancelling translation object '{}'", (Object)translationObject.getAemTranslationObjectId());
        AemTranslationProject project = translationObject.getProject();
        AemTranslationJob job = translationObject.getJob();
        TranslationCloudConfig config = project.getConfig();
        Long xtmProjectId = job.getXtmProjectId();
        if (job.getAemTranslationObjects().size() == 1 && this.isOnlyAemJobWithinXtmProject(job, project)) {
            this.cancelProject(xtmProjectId, config);
            return;
        }
        ImmutableList xtmJobIdsToDelete = ImmutableList.of((Object)translationObject.getXtmJobId());
        LanguageCODE targetLanguage = TranslationController.getTargetLanguageCode(job);
        this.deleteJobsFromXtmProject(config, xtmProjectId, (List<Long>)xtmJobIdsToDelete, targetLanguage);
    }

    private void cancelProject(Long projectId, TranslationCloudConfig config) throws TranslationException {
        this.cancelProjects(Collections.singletonList(projectId), config);
    }

    private void cancelProjects(Collection<Long> projectIds, TranslationCloudConfig config) throws TranslationException {
        XtmPROJECTACTIVITY activity;
        switch (config.getProjectCancellationStrategy()) {
            case DELETE_KEEP_TM: {
                activity = XtmPROJECTACTIVITY.DELETE_LEAVING_TM;
                break;
            }
            case DELETE_WITH_TM: {
                activity = XtmPROJECTACTIVITY.DELETE_WITH_TM;
                break;
            }
            default: {
                activity = XtmPROJECTACTIVITY.ARCHIVE;
            }
        }
        this.actionFactory.getUpdateProjectActivityAction(projectIds, activity, config).run();
    }

    private void deleteJobsFromXtmProject(TranslationCloudConfig config, Long xtmProjectId, List<Long> xtmJobIds, LanguageCODE targetLanguage) throws TranslationException {
        XtmProjectStatusResponseAPI projectStatus = this.actionFactory.getCheckProjectCompletionAction(xtmProjectId, config).run();
        List<String> fileNames = projectStatus.getJobs().stream().filter(xtmJob -> targetLanguage.equals((Object)xtmJob.getTargetLanguage())).filter(xtmJob -> xtmJobIds.contains(xtmJob.getJobDescriptor().getId())).map(XtmJobStatusResponseAPI::getFileName).collect(Collectors.toList());
        this.actionFactory.getDeleteTranslationFilesAction(xtmProjectId, (Collection<LanguageCODE>)ImmutableList.of((Object)((Object)targetLanguage)), fileNames, config).run();
    }

    private boolean isOnlyAemJobWithinXtmProject(AemTranslationJob job, AemTranslationProject project) {
        return project.getTranslationJobs().stream().map(AemTranslationJob::getXtmProjectId).filter(job.getXtmProjectId()::equals).count() == 1L;
    }
}

