/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.raw.RawGuiInteractions;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.soap.legacy.ObtainProjectStatusSoapAction;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")}, immediate=true)
@Designate(ocd=Configuration.class)
public class XtmSideProjectStarter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(XtmSideProjectStarter.class);
    static final String SCHEDULER_JOB_TOPIC = "xtm-side-translation-project-start";
    static final String DEFAULT_CRON_EXPRESSION = "17 17 * ? * * *";
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverProvider resourceResolverProvider;
    @Reference
    private RawGuiInteractions gui;
    private String cronExpression;

    @Activate
    public void activate(Configuration configuration) {
        this.cronExpression = (String)StringUtils.defaultIfBlank((CharSequence)configuration.cron_expression(), (CharSequence)DEFAULT_CRON_EXPRESSION);
        this.removeScheduler();
        this.startScheduledJob();
    }

    @Override
    public void run() {
        try (ResourceResolver resourceResolver = this.resourceResolverProvider.getXtmResourceResolver();){
            resourceResolver.refresh();
            Resource jobRoot = resourceResolver.getResource("/var/xtm/translationJobs");
            for (Resource jobResource : Objects.requireNonNull(jobRoot).getChildren()) {
                try {
                    ObtainProjectStatusSoapAction action;
                    TranslationConstants.TranslationStatus currentStatus;
                    AemTranslationJob job = (AemTranslationJob)jobResource.adaptTo(AemTranslationJob.class);
                    if (job == null || !job.isSentToXtm() || !TranslationConstants.TranslationStatus.SCOPE_COMPLETED.equals((Object)job.getRawJob().getTranslationStatus()) || !TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS.equals((Object)(currentStatus = (TranslationConstants.TranslationStatus)(action = new ObtainProjectStatusSoapAction(job.getXtmProjectId(), job.getProject().getConfig())).runWithHandlers()))) continue;
                    this.gui.start(job.getRawJob(), resourceResolver);
                }
                catch (TranslationException | IllegalArgumentException e) {
                    log.error("Failed to verify project status on XTM side for job '{}'", (Object)jobResource.getPath(), (Object)e);
                }
            }
        }
        catch (LoginException e) {
            log.error("Failed to verify project status on XTM side", (Throwable)e);
        }
    }

    private void removeScheduler() {
        log.trace("Unschedule all jobs: {}", (Object)SCHEDULER_JOB_TOPIC);
        this.scheduler.unschedule(SCHEDULER_JOB_TOPIC);
    }

    private void startScheduledJob() {
        ScheduleOptions options = this.scheduler.EXPR(this.cronExpression).canRunConcurrently(false).name(SCHEDULER_JOB_TOPIC);
        this.scheduler.schedule((Object)this, options);
    }

    @ObjectClassDefinition(name="XTM-side Project Starting Scheduler", description="Defines when automated starting of projects started on XTM side occurs")
    public static @interface Configuration {
        @AttributeDefinition(name="CRON Expression", description="Valid Quartz CRON expression i.e. '0 * * ? * *' - will fire every minute. By default XTM-side project starting is checked once every hour.", defaultValue={"17 17 * ? * * *"})
        public String cron_expression();
    }
}

