/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.raw.RawTranslationPage;
import com.xtm.aem.api.services.preview.PreviewFactory;
import com.xtm.aem.api.services.preview.PreviewGenerator;
import com.xtm.aem.api.services.preview.PreviewZipEntry;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.TranslationEntry;
import com.xtm.aem.models.zip.PreviewZipFileModel;
import com.xtm.aem.services.translation.preview.zip.PreviewZipUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmPreviewFactory
implements PreviewFactory {
    private static final Pattern HTML_SPACE_SPLITTER = Pattern.compile("(?<![ \\w.,])(?> |&nbsp;)+(?![ \\w.,])");
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewFactory.class);
    @Reference
    private PreviewGenerator previewGenerator;

    @Override
    public PreviewZipFile getPreview(AemTranslationJob aemTranslationJob) {
        PreviewZipFile previewZip = this.getBasePreview(aemTranslationJob);
        previewZip = PreviewZipUtils.rename(previewZip, PreviewZipUtils.STANDARDIZE_SLASHES);
        previewZip = PreviewZipUtils.rename(previewZip, PreviewZipUtils.STRIP_LEADING_SLASH);
        Map<String, String> nameMapping = this.getNameMapping(aemTranslationJob);
        Function<String, String> renamingFunction = PreviewZipUtils.getNameMappingFunction(nameMapping);
        previewZip = PreviewZipUtils.rename(previewZip, renamingFunction);
        return previewZip;
    }

    private PreviewZipFile getBasePreview(AemTranslationJob aemTranslationJob) {
        TranslationCloudConfig config = aemTranslationJob.getProject().getConfig();
        switch (config.getPreviewGenerationStrategy()) {
            case AEM: {
                return this.getAemPreviewFile(aemTranslationJob);
            }
            case XTM: {
                return this.getXtmPreviewFile(aemTranslationJob);
            }
        }
        return new PreviewZipFileModel();
    }

    private PreviewZipFile getAemPreviewFile(AemTranslationJob aemTranslationJob) {
        List<PreviewZipFile> previewZips = aemTranslationJob.getAemTranslationObjects().stream().map(AemTranslationObject::getContentSyncPreview).filter(Objects::nonNull).collect(Collectors.toList());
        PreviewZipFile previewZip = PreviewZipUtils.aggregate(previewZips);
        return previewZip;
    }

    private PreviewZipFile getXtmPreviewFile(AemTranslationJob aemTranslationJob) {
        PreviewZipFile previewZip = this.getBaseXtmPreviewFile(aemTranslationJob);
        for (AemTranslationObject ato : aemTranslationJob.getAemTranslationObjects()) {
            String entryContent;
            PreviewZipEntry entry;
            block5: {
                entry = (PreviewZipEntry)previewZip.get(ato.getSourcePath() + ".html");
                if (entry == null) continue;
                entryContent = entry.getStringContent();
                entryContent = StringUtils.replace((String)entryContent, (String)"\u00a0", (String)"&nbsp;");
                TranslationEntry currentEntry = null;
                try {
                    Iterator<TranslationEntry> iterator = ato.getTranslationFile().getEntries().iterator();
                    while (iterator.hasNext()) {
                        TranslationEntry translationEntry;
                        currentEntry = translationEntry = iterator.next();
                        for (String text : translationEntry.getTexts()) {
                            String patternedText = this.getPatternedText(text);
                            String replacement = this.getReplacementPattern(translationEntry, text);
                            entryContent = entryContent.replaceAll(patternedText, replacement);
                        }
                    }
                }
                catch (Exception e) {
                    if (currentEntry != null) break block5;
                    throw e;
                }
            }
            entry.setContent(entryContent.getBytes(PreviewGenerator.CHARSET));
        }
        return previewZip;
    }

    private PreviewZipFile getBaseXtmPreviewFile(AemTranslationJob aemTranslationJob) {
        Collection paths = aemTranslationJob.getAemTranslationObjects().stream().map(AemTranslationObject::getRawPage).map(RawTranslationPage::getSourcePath).collect(Collectors.toList());
        try {
            return this.previewGenerator.getPreview(paths);
        }
        catch (XtmConnectorException e) {
            log.error("Could not generate preview for job '{}'", (Object)aemTranslationJob.getAemJobId(), (Object)e);
            return new PreviewZipFileModel();
        }
    }

    private Map<String, String> getNameMapping(AemTranslationJob aemTranslationJob) {
        return aemTranslationJob.getAemTranslationObjects().stream().filter(ato -> StringUtils.isNotBlank((CharSequence)ato.getRawPage().getSourcePath())).collect(Collectors.toMap(ato -> ato.getRawPage().getSourcePath().substring(1) + ".html", ato -> StringUtils.substringBeforeLast((String)ato.getRawPage().getSourcePath().substring(1), (String)"/") + "/" + ato.getFileName().replace(".xml", ".html")));
    }

    private String getPatternedText(String text) {
        String[] textParts = HTML_SPACE_SPLITTER.split(text);
        return Arrays.stream(textParts).filter(StringUtils::isNotBlank).map(Pattern::quote).collect(Collectors.joining("(?: |&nbsp;)+", "(?<=\\>)(?<pre>\\s*)", "(?<suf>\\s*)(?=\\<)"));
    }

    private String getReplacementPattern(TranslationEntry translationEntry, String text) {
        return "<div data-previewnodepath=\"" + translationEntry.getPath() + "\" data-previewpropertyname=\"" + translationEntry.getPropertyName() + "\">${pre}" + text.replace("$", "\\$") + "${suf}</div>";
    }
}

