/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.wcm.api.WCMMode;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.preview.PreviewGenerator;
import com.xtm.aem.api.services.preview.PreviewItem;
import com.xtm.aem.api.services.preview.PreviewItemFactory;
import com.xtm.aem.services.shared.requests.FakeRequestWrapper;
import com.xtm.aem.services.shared.requests.FakeResponseWrapper;
import com.xtm.aem.services.translation.preview.items.CssPreviewItem;
import com.xtm.aem.services.translation.preview.items.DefaultPreviewItem;
import com.xtm.aem.services.translation.preview.items.EmptyPreviewItem;
import com.xtm.aem.services.translation.preview.items.HtmlPreviewItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmPreviewItemFactory
implements PreviewItemFactory {
    @Reference
    private SlingRequestProcessor requestProcessor;
    @Reference
    private RequestResponseFactory requestResponseFactory;

    @Override
    public PreviewItem getPreviewItem(String path, ResourceResolver resourceResolver) {
        String extension;
        HttpServletRequest request = this.getRequest(path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpServletResponse response = this.getResponse(baos);
        try {
            this.requestProcessor.processRequest(request, response, resourceResolver);
        }
        catch (IOException | ServletException e) {
            return EmptyPreviewItem.INSTANCE;
        }
        if (response.getStatus() >= 400) {
            return EmptyPreviewItem.INSTANCE;
        }
        String characterEncoding = response.getCharacterEncoding();
        switch (extension = StringUtils.substringAfterLast((String)path, (String)".")) {
            case "html": {
                return new HtmlPreviewItem(path, baos, characterEncoding);
            }
            case "css": {
                return new CssPreviewItem(path, baos, characterEncoding);
            }
        }
        return new DefaultPreviewItem(path, baos, characterEncoding);
    }

    private HttpServletRequest getRequest(String pagePath) {
        HttpServletRequest fakeRequest = this.requestResponseFactory.createRequest("GET", pagePath);
        fakeRequest.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)WCMMode.DISABLED);
        FakeRequestWrapper request = new FakeRequestWrapper(fakeRequest);
        try {
            request.setCharacterEncoding(PreviewGenerator.CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("'" + PreviewGenerator.CHARACTER_ENCODING + "' encoding is unsupported", e);
        }
        return request;
    }

    private HttpServletResponse getResponse(ByteArrayOutputStream baos) {
        HttpServletResponse fakeResponse = this.requestResponseFactory.createResponse((OutputStream)baos);
        return new FakeResponseWrapper(fakeResponse);
    }
}

