/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.items;

import com.xtm.aem.services.translation.preview.items.BasePreviewItem;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlPreviewItem
extends BasePreviewItem {
    private static final Pattern htmlRefPattern = Pattern.compile("=\"((/([^ ]*?))(\\.[^ ]*))(?<!\\.html)(\")");
    private String htmlContent;
    private Collection<String> references;

    public HtmlPreviewItem(String path, ByteArrayOutputStream baos, String characterEncoding) {
        super(path, baos, characterEncoding);
    }

    @Override
    public String getContent() {
        if (this.htmlContent == null) {
            String contentWithReplacedRefs = this.rawContent;
            int level = this.getPath().split("/").length - 2;
            String prefix = String.join((CharSequence)"/", Collections.nCopies(level, ".."));
            for (String refPath : this.getReferences()) {
                contentWithReplacedRefs = StringUtils.replace((String)contentWithReplacedRefs, (String)refPath, (String)(prefix + refPath));
            }
            this.htmlContent = contentWithReplacedRefs;
        }
        return this.htmlContent;
    }

    @Override
    public Collection<String> getReferences() {
        if (this.references == null) {
            this.references = new HashSet<String>();
            Matcher matcher = htmlRefPattern.matcher(this.rawContent);
            while (matcher.find()) {
                String[] parts;
                String newMatch = matcher.group(1);
                if (!newMatch.contains(".") || "html".equals((parts = newMatch.split("\\."))[parts.length - 1])) continue;
                this.references.add(newMatch);
            }
        }
        return this.references;
    }
}

