/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.servlets;

import com.adobe.cq.projects.api.Project;
import com.adobe.cq.projects.api.ProjectManager;
import com.google.common.collect.ImmutableList;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.models.ui.SendToTranslationFormDataModel;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=XTM Create project", "sling.servlet.methods=POST", "sling.servlet.paths=/services/xtm/xtm-translation-project"})
public class TranslationProjectCreationServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TranslationProjectCreationServlet.class);
    private static final Pattern GADGET_TITLE_REPLACEMENT = Pattern.compile("\\[[A-Za-z-_]*?]");
    private static final String TRANSLATION_GADGET_PATH = "jcr:content/dashboard/gadgets/translationjob";
    private static final String PROJECT_OWNER = "owner";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        SendToTranslationFormDataModel formModel = (SendToTranslationFormDataModel)Objects.requireNonNull(request.adaptTo(SendToTranslationFormDataModel.class));
        try {
            Project project = this.createProject(resourceResolver, formModel);
            Resource projectResource = (Resource)Objects.requireNonNull(project.adaptTo(Resource.class));
            TranslationProjectCreationServlet.assignOwner(project, Objects.requireNonNull(resourceResolver.getUserID()));
            String[] targetLanguages = formModel.getTargetLanguages();
            this.updateTranslationGadget(projectResource, targetLanguages[0]);
            for (int i = 1; i < targetLanguages.length; ++i) {
                this.cloneTranslationGadget(projectResource, targetLanguages[i]);
            }
            String createdProjectJson = this.getJsonMapping(projectResource);
            resourceResolver.commit();
            TranslationProjectCreationServlet.outputResults(response, createdProjectJson);
        }
        catch (IOException exception) {
            log.error("Unable to create project", (Throwable)exception);
            TranslationProjectCreationServlet.outputError(response, exception);
            response.setStatus(500);
        }
    }

    private String getJsonMapping(Resource projectResource) {
        RawTranslationProject rawProject = (RawTranslationProject)Objects.requireNonNull(projectResource.adaptTo(RawTranslationProject.class));
        JsonObjectBuilder mappingBuilder = Json.createObjectBuilder();
        rawProject.getTranslationJobs().forEach(rtj -> mappingBuilder.add(rtj.getDestinationLanguage(), rtj.getPath()));
        return Json.createObjectBuilder().add("projectPath", projectResource.getPath()).add("languageToTranslationJobPath", mappingBuilder).build().toString();
    }

    private Project createProject(ResourceResolver resourceResolver, SendToTranslationFormDataModel projectModel) {
        Optional<Project> project = Optional.of(resourceResolver).map(rr -> (ProjectManager)rr.adaptTo(ProjectManager.class)).map(pm -> pm.createProject("/content/projects", projectModel.getProjectName(), projectModel.getProjectName(), "/libs/cq/core/content/projects/templates/translation-project"));
        Map<String, Object> properties = projectModel.asPropertyMap();
        project.map(p -> (Resource)p.adaptTo(Resource.class)).map(r -> r.getChild("jcr:content")).map(r -> (ModifiableValueMap)r.adaptTo(ModifiableValueMap.class)).orElseThrow(() -> new IllegalStateException("Could not create AEM project")).putAll(properties);
        return project.get();
    }

    private void updateTranslationGadget(Resource projectResource, String targetLanguage) {
        Resource gadgetResource = Objects.requireNonNull(projectResource.getChild(TRANSLATION_GADGET_PATH));
        ModifiableValueMap mvm = (ModifiableValueMap)Objects.requireNonNull(gadgetResource.adaptTo(ModifiableValueMap.class));
        mvm.put((Object)"destinationLanguage", (Object)targetLanguage);
        String oldTitle = (String)mvm.get("jcr:title", (Object)"");
        String newTitle = GADGET_TITLE_REPLACEMENT.matcher(oldTitle).replaceAll(" [" + targetLanguage + "]");
        mvm.put((Object)"jcr:title", (Object)newTitle);
    }

    private void cloneTranslationGadget(Resource projectResource, String targetLanguage) throws PersistenceException {
        ResourceResolver resourceResolver = projectResource.getResourceResolver();
        Resource firstGadgetResource = Objects.requireNonNull(projectResource.getChild(TRANSLATION_GADGET_PATH));
        Resource gadgetRootResource = Objects.requireNonNull(firstGadgetResource.getParent());
        String name = ResourceUtil.createUniqueChildName((Resource)gadgetRootResource, (String)"translationjob");
        Resource gadgetResource = resourceResolver.create(gadgetRootResource, name, (Map)firstGadgetResource.getValueMap());
        for (Resource child : firstGadgetResource.getChildren()) {
            resourceResolver.copy(child.getPath(), gadgetResource.getPath());
        }
        ModifiableValueMap mvm = (ModifiableValueMap)Objects.requireNonNull(gadgetResource.adaptTo(ModifiableValueMap.class));
        mvm.put((Object)"destinationLanguage", (Object)targetLanguage);
        String oldTitle = (String)mvm.get("jcr:title", (Object)"");
        String newTitle = GADGET_TITLE_REPLACEMENT.matcher(oldTitle).replaceAll(" [" + targetLanguage + "]");
        mvm.put((Object)"jcr:title", (Object)newTitle);
    }

    private static void assignOwner(Project project, String userID) {
        ImmutableList userIdList = ImmutableList.of((Object)userID);
        ImmutableList roleList = ImmutableList.of((Object)PROJECT_OWNER);
        project.updateMembers((List)userIdList, (List)roleList);
    }

    private static void outputResults(SlingHttpServletResponse response, String createdProjectJson) throws IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        out.print(createdProjectJson);
        out.flush();
    }

    private static void outputError(SlingHttpServletResponse response, Exception exception) {
        response.setStatus(500);
        try {
            PrintWriter out = response.getWriter();
            response.setContentType("text/plain");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            out.print("Unable to create project:\n" + exception.getMessage());
            out.flush();
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }
}

