/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.actions;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.api.BaseXtmSoapAction;
import com.xtm.aem.soap.api.JaxWsClientFactory;
import com.xtm.aem.soap.wsdl.PMWAuthenticationException;
import com.xtm.aem.soap.wsdl.PMWIllegalParametersException;
import com.xtm.aem.soap.wsdl.PMWProcessingException;
import com.xtm.aem.soap.wsdl.XtmCheckProjectAnalysisCompletionOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmCheckProjectAnalysisCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmPROJECTCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdl.XtmProjectDescriptorAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmProjectDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePostAnalysisAction<T>
extends BaseXtmSoapAction<T> {
    protected static final Logger log = LoggerFactory.getLogger(BasePostAnalysisAction.class);
    private static final int MAX_RETRIES = 2000;
    private static final int RETRY_INTERVAL = 2000;
    protected final XtmProjectDescriptorAPI projectDescriptor;
    private final XtmCheckProjectAnalysisCompletionOptionsAPI options = new XtmCheckProjectAnalysisCompletionOptionsAPI();

    protected BasePostAnalysisAction(TranslationCloudConfig cloudConfig, JaxWsClientFactory clientFactory, Long projectId) {
        super(cloudConfig, clientFactory);
        this.projectDescriptor = new XtmProjectDescriptor(projectId);
    }

    @Override
    protected final T runInternal() throws Exception {
        this.waitForAnalysis();
        return this.runAfterAnalysisFinished();
    }

    protected T runAfterAnalysisFinished() throws Exception {
        return null;
    }

    protected final void waitForAnalysis() throws PMWProcessingException, PMWIllegalParametersException, PMWAuthenticationException, InterruptedException, XtmConnectorException {
        XtmCheckProjectAnalysisCompletionResponseAPI xtmResponse = null;
        Login loginAPI = new Login(this.cloudConfig);
        for (int i = 0; i < 2000; ++i) {
            xtmResponse = this.xtmWebService.checkProjectAnalysisCompletion(loginAPI, this.projectDescriptor, this.options);
            log.debug("Project '{}', status: '{}'", (Object)this.projectDescriptor.getId(), (Object)xtmResponse.getProject().getStatus());
            if (xtmResponse.getProject().getStatus() == XtmPROJECTCOMPLETIONSTATUS.FINISHED) break;
            Thread.sleep(2000L);
        }
        if (xtmResponse.getProject().getStatus() != XtmPROJECTCOMPLETIONSTATUS.FINISHED) {
            throw new XtmConnectorException("Maximum number of retries exceeded while checking for analysis completion in XTM");
        }
    }
}

