/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.actions.BasePostAnalysisAction;
import com.xtm.aem.soap.api.JaxWsClientFactory;
import com.xtm.aem.soap.wsdl.XtmCheckProjectCompletionOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmCheckProjectCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmProjectStatusResponseAPI;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CheckProjectCompletionAction
extends BasePostAnalysisAction<XtmProjectStatusResponseAPI> {
    private static final Logger log = LoggerFactory.getLogger(CheckProjectCompletionAction.class);
    private final XtmCheckProjectCompletionOptionsAPI checkProjectCompletionOptions;

    CheckProjectCompletionAction(Long projectId, TranslationCloudConfig xtmCloudConfig, JaxWsClientFactory clientFactory) {
        super(xtmCloudConfig, clientFactory, projectId);
        Validate.notNull((Object)projectId, (String)"Missing mandatory parameter 'projectId'", (Object[])new Object[0]);
        this.checkProjectCompletionOptions = null;
    }

    @Override
    protected XtmProjectStatusResponseAPI runAfterAnalysisFinished() throws Exception {
        log.info("Checking completion of project with ID '{}'...", (Object)this.projectDescriptor.getId());
        XtmCheckProjectCompletionResponseAPI xtmResponse = this.xtmWebService.checkProjectCompletion(this.loginDescriptor, this.projectDescriptor, this.checkProjectCompletionOptions);
        XtmProjectStatusResponseAPI project = xtmResponse.getProject();
        if (project != null) {
            log.info("Project '{}' in state '{}'.", (Object)this.projectDescriptor.getId(), (Object)project.getActivity());
        } else {
            log.info("Could not check completion status of project '{}'", (Object)this.projectDescriptor.getId());
        }
        return project;
    }
}

