/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.actions;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.actions.BasePostAnalysisAction;
import com.xtm.aem.soap.actions.CheckProjectCompletionAction;
import com.xtm.aem.soap.api.JaxWsClientFactory;
import com.xtm.aem.soap.wsdl.LanguageCODE;
import com.xtm.aem.soap.wsdl.XtmAddTranslationFilesMTOMAPI;
import com.xtm.aem.soap.wsdl.XtmDeleteTranslationFilesAPI;
import com.xtm.aem.soap.wsdl.XtmJOBCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdl.XtmJobResponseAPI;
import com.xtm.aem.soap.wsdl.XtmJobStatusResponseAPI;
import com.xtm.aem.soap.wsdl.XtmProjectResponseAPI;
import com.xtm.aem.soap.wsdl.XtmProjectStatusResponseAPI;
import com.xtm.aem.soap.wsdl.XtmUpdateTranslationFilesMTOMAPI;
import com.xtm.aem.soap.wsdl.XtmUpdateTranslationFilesMTOMOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmUpdateTranslationFilesMTOMResponseAPI;
import com.xtm.aem.soap.wsdlextensions.XtmDeleteFileDescriptor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTranslationFilesAction
extends BasePostAnalysisAction<List<XtmJobResponseAPI>> {
    private static final Logger log = LoggerFactory.getLogger(DeleteTranslationFilesAction.class);
    private final XtmUpdateTranslationFilesMTOMAPI files = new XtmUpdateTranslationFilesMTOMAPI();
    private final XtmUpdateTranslationFilesMTOMOptionsAPI options = new XtmUpdateTranslationFilesMTOMOptionsAPI();
    private final Collection<LanguageCODE> languagesToDelete;
    private final Collection<String> filesToDelete;

    protected DeleteTranslationFilesAction(Long projectId, Collection<LanguageCODE> languagesToDelete, Collection<String> filesToDelete, TranslationCloudConfig cloudConfig, JaxWsClientFactory clientFactory) {
        super(cloudConfig, clientFactory, projectId);
        this.files.setProjectDescriptor(this.projectDescriptor);
        this.languagesToDelete = languagesToDelete;
        this.filesToDelete = filesToDelete;
    }

    @Override
    protected List<XtmJobResponseAPI> runAfterAnalysisFinished() throws Exception {
        log.info("Deleting files from project with ID '{}'...", (Object)this.projectDescriptor.getId());
        XtmDeleteTranslationFilesAPI filesToDelete = this.getFilesToDelete();
        this.files.setFilesToDelete(filesToDelete);
        XtmAddTranslationFilesMTOMAPI filesToAdd = this.getFilesToAdd();
        this.files.setFilesToAdd(filesToAdd);
        if (this.noFilesToDelete(filesToDelete) && this.noFilesToAdd(filesToAdd)) {
            return null;
        }
        XtmUpdateTranslationFilesMTOMResponseAPI xtmResponse = this.xtmWebService.updateTranslationFilesMTOM(this.loginDescriptor, this.files, this.options);
        XtmProjectResponseAPI project = xtmResponse.getProject();
        List<XtmJobResponseAPI> jobs = project.getJobs();
        if (jobs != null) {
            log.info("Successfully updated jobs within project '{}'.", (Object)this.projectDescriptor.getId());
        } else {
            log.info("Could not retrieve status of jobs in project '{}'", (Object)this.projectDescriptor.getId());
        }
        return jobs;
    }

    private boolean noFilesToAdd(XtmAddTranslationFilesMTOMAPI filesToAdd) {
        return filesToAdd == null || CollectionUtils.isEmpty(filesToAdd.getTranslationFiles());
    }

    private boolean noFilesToDelete(XtmDeleteTranslationFilesAPI filesToDelete) {
        return filesToDelete == null || CollectionUtils.isEmpty(filesToDelete.getTranslationFiles());
    }

    protected XtmDeleteTranslationFilesAPI getFilesToDelete() throws TranslationException {
        XtmDeleteTranslationFilesAPI deletionDescriptor = new XtmDeleteTranslationFilesAPI();
        deletionDescriptor.getTargetLanguages().addAll(this.languagesToDelete);
        ((XtmProjectStatusResponseAPI)new CheckProjectCompletionAction(this.projectDescriptor.getId(), this.cloudConfig, this.clientFactory).run()).getJobs().stream().filter(jobStatus -> this.languagesToDelete.contains((Object)jobStatus.getTargetLanguage())).filter(jobStatus -> XtmJOBCOMPLETIONSTATUS.IN_PROGRESS.equals((Object)jobStatus.getStatus())).map(XtmJobStatusResponseAPI::getFileName).distinct().filter(this.filesToDelete::contains).map(XtmDeleteFileDescriptor::new).forEach(deletionDescriptor.getTranslationFiles()::add);
        return deletionDescriptor;
    }

    protected XtmAddTranslationFilesMTOMAPI getFilesToAdd() {
        return null;
    }
}

