/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.actions;

import com.google.common.collect.ImmutableSet;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.api.BaseXtmSoapAction;
import com.xtm.aem.soap.api.JaxWsClientFactory;
import com.xtm.aem.soap.wsdl.XtmPROJECTACTIVITY;
import com.xtm.aem.soap.wsdl.XtmProjectActivityResponseAPI;
import com.xtm.aem.soap.wsdl.XtmProjectDescriptorAPI;
import com.xtm.aem.soap.wsdl.XtmUpdateProjectActivityOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmUpdateProjectActivityResponseAPI;
import com.xtm.aem.soap.wsdlextensions.XtmProjectDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UpdateProjectActivityAction
extends BaseXtmSoapAction<Map<Long, Boolean>> {
    private static final Logger log = LoggerFactory.getLogger(UpdateProjectActivityAction.class);
    private final List<XtmProjectDescriptorAPI> projectDescriptors;
    private final XtmUpdateProjectActivityOptionsAPI updateProjectOptions;
    private final Collection<Long> projectIds;

    UpdateProjectActivityAction(Long projectId, XtmPROJECTACTIVITY activity, TranslationCloudConfig xtmCloudConfig, JaxWsClientFactory clientFactory) {
        this((Collection<Long>)ImmutableSet.of((Object)projectId), activity, xtmCloudConfig, clientFactory);
    }

    UpdateProjectActivityAction(Collection<Long> projectIds, XtmPROJECTACTIVITY activity, TranslationCloudConfig xtmCloudConfig, JaxWsClientFactory clientFactory) {
        super(xtmCloudConfig, clientFactory);
        Validate.notNull(projectIds, (String)"Missing mandatory parameter 'projectIds'", (Object[])new Object[0]);
        this.projectDescriptors = projectIds.stream().distinct().map(XtmProjectDescriptor::new).collect(Collectors.toList());
        this.updateProjectOptions = new XtmUpdateProjectActivityOptionsAPI();
        this.updateProjectOptions.setActivity(activity);
        this.projectIds = projectIds;
    }

    @Override
    protected Map<Long, Boolean> runInternal() throws Exception {
        log.info("Archiving projects with IDs '{}'...", this.projectIds);
        XtmUpdateProjectActivityResponseAPI xtmResponse = this.xtmWebService.updateProjectActivity(this.loginDescriptor, this.projectDescriptors, this.updateProjectOptions);
        List<XtmProjectActivityResponseAPI> projects = xtmResponse.getProjects();
        Map<Long, Boolean> result = this.projectIds.stream().collect(Collectors.toMap(Function.identity(), id -> false));
        if (projects != null) {
            projects.stream().filter(XtmProjectActivityResponseAPI::isResult).map(XtmProjectActivityResponseAPI::getProjectDescriptor).filter(Objects::nonNull).map(XtmProjectDescriptorAPI::getId).forEach(id -> result.put((Long)id, true));
        }
        log.info("Archiving result map: '{}'", result);
        return result;
    }
}

