/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.actions;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.actions.CheckProjectCompletionAction;
import com.xtm.aem.soap.actions.DeleteTranslationFilesAction;
import com.xtm.aem.soap.actions.StartProjectAction;
import com.xtm.aem.soap.actions.UpdateProjectActivityAction;
import com.xtm.aem.soap.api.ActionFactory;
import com.xtm.aem.soap.api.JaxWsClientFactory;
import com.xtm.aem.soap.wsdl.LanguageCODE;
import com.xtm.aem.soap.wsdl.XtmJobResponseAPI;
import com.xtm.aem.soap.wsdl.XtmPROJECTACTIVITY;
import com.xtm.aem.soap.wsdl.XtmProjectStatusResponseAPI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmActionFactory
implements ActionFactory {
    @Reference
    private JaxWsClientFactory clientFactory;

    @Override
    public XtmAction<Boolean> getStartProjectAction(Long projectId, TranslationCloudConfig config) {
        return new StartProjectAction(projectId, config, this.clientFactory);
    }

    @Override
    public XtmAction<Map<Long, Boolean>> getUpdateProjectActivityAction(Long projectId, XtmPROJECTACTIVITY activity, TranslationCloudConfig config) {
        return new UpdateProjectActivityAction(projectId, activity, config, this.clientFactory);
    }

    @Override
    public XtmAction<Map<Long, Boolean>> getUpdateProjectActivityAction(Collection<Long> projectIds, XtmPROJECTACTIVITY activity, TranslationCloudConfig config) {
        return new UpdateProjectActivityAction(projectIds, activity, config, this.clientFactory);
    }

    @Override
    public XtmAction<XtmProjectStatusResponseAPI> getCheckProjectCompletionAction(Long projectId, TranslationCloudConfig config) {
        return new CheckProjectCompletionAction(projectId, config, this.clientFactory);
    }

    @Override
    public XtmAction<List<XtmJobResponseAPI>> getDeleteTranslationFilesAction(Long projectId, Collection<LanguageCODE> languagesToDelete, Collection<String> filesToDelete, TranslationCloudConfig config) {
        return new DeleteTranslationFilesAction(projectId, languagesToDelete, filesToDelete, config, this.clientFactory);
    }
}

