/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.api;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.api.JaxWsClientFactory;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.PMWAuthenticationException;
import com.xtm.aem.soap.wsdl.PMWIllegalParametersException;
import com.xtm.aem.soap.wsdl.PMWProcessingException;
import com.xtm.aem.soap.wsdl.ProjectManagerMTOMWebService;
import com.xtm.aem.soap.wsdlextensions.Login;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.commons.lang3.Validate;

public abstract class BaseXtmSoapAction<T>
implements XtmAction<T> {
    protected final TranslationCloudConfig cloudConfig;
    protected final LoginAPI loginDescriptor;
    protected final JaxWsClientFactory clientFactory;
    protected final ProjectManagerMTOMWebService xtmWebService;

    protected BaseXtmSoapAction(TranslationCloudConfig cloudConfig, JaxWsClientFactory clientFactory) {
        Validate.notNull((Object)cloudConfig, (String)"'cloudConfig' cannot be null", (Object[])new Object[0]);
        this.cloudConfig = cloudConfig;
        this.loginDescriptor = new Login(cloudConfig);
        this.clientFactory = clientFactory;
        this.xtmWebService = clientFactory.create(ProjectManagerMTOMWebService.class, cloudConfig.getWebserviceUri(), cloudConfig.getProxyConfiguration());
    }

    @Override
    public final T run() throws TranslationException {
        try {
            return this.runInternal();
        }
        catch (PMWAuthenticationException e) {
            throw new TranslationException("Error while authenticating with XTM", (Throwable)e, TranslationException.ErrorCode.NOT_AUTHORIZED);
        }
        catch (PMWIllegalParametersException e) {
            throw new TranslationException("Error in XTM parameters", (Throwable)e, TranslationException.ErrorCode.MISSING_PARAMETER);
        }
        catch (PMWProcessingException e) {
            throw new TranslationException("Error in XTM processing", (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (ConnectException | UnknownHostException e) {
            throw new TranslationException("A network error occurred when connecting to XTM", (Throwable)e, TranslationException.ErrorCode.ENGINE_TEMP_UNAVAILABLE);
        }
        catch (XtmConnectorException e) {
            throw new TranslationException("An error occurred while communicating with XTM", (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (Exception e) {
            throw new TranslationException("Unspecified error when calling XTM", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    protected abstract T runInternal() throws Exception;
}

