/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.legacy.jaxws.JaxWsClientFactoryImpl;
import com.xtm.aem.soap.wsdl.PMWAuthenticationException;
import com.xtm.aem.soap.wsdl.PMWIllegalParametersException;
import com.xtm.aem.soap.wsdl.PMWProcessingException;
import com.xtm.aem.soap.wsdl.ProjectManagerMTOMWebService;
import com.xtm.aem.soap.wsdl.XtmCheckProjectAnalysisCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmPROJECTCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmProjectDescriptor;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXtmServiceSoapAction<T>
implements XtmServiceAction<T> {
    protected static final String XTM_FILE_TITLE_EXT = ".txt";
    protected static final String XTM_FILE_CONTENT_EXT = ".xml";
    protected static final Logger log = LoggerFactory.getLogger((String)"XTM Service");
    private static final int analysisCheckMaxRetries = 2000;
    private static final int analysisCheckRetryInterval = 2000;
    private final Long referenceId = 0L;
    protected ProjectManagerMTOMWebService xtmWebService = null;
    protected TranslationCloudConfig cloudConfig;
    protected ProxyConfiguration proxyConfiguration;
    private String webserviceUri;
    private String webserviceClient;
    private Long webserviceUserId;
    private String webservicePassword;
    private Long webserviceCustomerId;
    private Long webserviceTemplateId;

    private void initializeSoapConnection() throws XtmConnectorException {
        if (this.cloudConfig == null) {
            throw new XtmConnectorException("Error initializing required parameters for XTM connection.");
        }
        if (!(this.cloudConfig.getWebserviceUri().equals(this.webserviceUri) && this.cloudConfig.getClient().equals(this.webserviceClient) && this.cloudConfig.getUserId().equals(this.webserviceUserId) && this.cloudConfig.getPassword().equals(this.webservicePassword) && this.cloudConfig.getCustomerId().equals(this.webserviceCustomerId) && this.cloudConfig.getTemplateId().equals(this.webserviceTemplateId))) {
            this.webserviceUri = this.cloudConfig.getWebserviceUri();
            this.webserviceClient = this.cloudConfig.getClient();
            this.webserviceUserId = this.cloudConfig.getUserId();
            this.webservicePassword = this.cloudConfig.getPassword();
            this.webserviceCustomerId = this.cloudConfig.getCustomerId();
            this.webserviceTemplateId = this.cloudConfig.getTemplateId();
            this.xtmWebService = null;
        }
        if (this.xtmWebService != null || this.webserviceUri.isEmpty()) {
            throw new XtmConnectorException("Required parameters not correctly initialized.");
        }
        this.xtmWebService = JaxWsClientFactoryImpl.create(ProjectManagerMTOMWebService.class, this.webserviceUri, this.proxyConfiguration);
    }

    @Override
    public final T runWithHandlers() throws TranslationException {
        try {
            this.initializeSoapConnection();
            return this.run();
        }
        catch (PMWAuthenticationException e) {
            throw new TranslationException("Error while authenticating with XTM", (Throwable)e, TranslationException.ErrorCode.NOT_AUTHORIZED);
        }
        catch (PMWIllegalParametersException e) {
            throw new TranslationException("Error in XTM parameters", (Throwable)e, TranslationException.ErrorCode.MISSING_PARAMETER);
        }
        catch (PMWProcessingException e) {
            throw new TranslationException("Error in XTM processing", (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (ConnectException | UnknownHostException e) {
            throw new TranslationException("A network error occurred when connecting to XTM", (Throwable)e, TranslationException.ErrorCode.ENGINE_TEMP_UNAVAILABLE);
        }
        catch (XtmConnectorException e) {
            throw new TranslationException("An error occurred while communicating with XTM", (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (Exception e) {
            throw new TranslationException("Unspecified error when calling XTM", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    protected abstract T run() throws Exception;

    Map<String, String> sortByValueComparator(Map<String, String> unsortMap, final boolean order) {
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    void waitForProjectAnalysisCompletion(Long projectId) throws PMWProcessingException, PMWIllegalParametersException, PMWAuthenticationException, InterruptedException, XtmConnectorException {
        XtmCheckProjectAnalysisCompletionResponseAPI xtmResponse = null;
        Login loginAPI = new Login(this.cloudConfig);
        for (int i = 0; i < 2000; ++i) {
            xtmResponse = this.xtmWebService.checkProjectAnalysisCompletion(loginAPI, new XtmProjectDescriptor(projectId), null);
            log.debug("Project [" + projectId + "], status: " + (Object)((Object)xtmResponse.getProject().getStatus()));
            if (xtmResponse.getProject() != null && xtmResponse.getProject().getStatus() == XtmPROJECTCOMPLETIONSTATUS.FINISHED) break;
            Thread.sleep(2000L);
        }
        if (xtmResponse.getProject().getStatus() != XtmPROJECTCOMPLETIONSTATUS.FINISHED) {
            throw new XtmConnectorException("Maximum number of retries exceeded while checking for analysis completion in XTM");
        }
    }
}

