/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.adobe.granite.translation.api.TranslationConstants;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.XtmCheckJobCompletionOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmCheckJobCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmJobDescriptorAPI;
import com.xtm.aem.soap.wsdl.XtmJobStatusResponseAPI;
import com.xtm.aem.soap.wsdl.XtmSTEPCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdl.XtmStepStatusResponseAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmJobDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ObtainJobStatusSoapAction
extends AbstractXtmServiceSoapAction<Map<Long, TranslationConstants.TranslationStatus>>
implements XtmServiceAction<Map<Long, TranslationConstants.TranslationStatus>> {
    private final LoginAPI loginAPI;
    private final List<XtmJobDescriptorAPI> jobDescriptors;
    private final XtmCheckJobCompletionOptionsAPI jobCompletionOptions;
    private String[] jobReferences;
    private Set<Long> jobIds;

    public ObtainJobStatusSoapAction(Set<Long> jobIds, TranslationCloudConfig xtmCloudConfig) {
        this.cloudConfig = xtmCloudConfig;
        this.jobIds = jobIds;
        this.loginAPI = new Login(this.cloudConfig);
        this.jobDescriptors = jobIds.stream().map(XtmJobDescriptor::new).collect(Collectors.toList());
        this.jobCompletionOptions = null;
        this.proxyConfiguration = xtmCloudConfig.getProxyConfiguration();
    }

    @Override
    protected Map<Long, TranslationConstants.TranslationStatus> run() throws Exception {
        log.info("Checking XTM Job Completion");
        XtmCheckJobCompletionResponseAPI xtmResponse = this.xtmWebService.checkJobCompletion(this.loginAPI, this.jobDescriptors, this.jobCompletionOptions);
        HashMap<Long, TranslationConstants.TranslationStatus> result = new HashMap();
        if (null == xtmResponse) {
            throw new XtmConnectorException("Empty response received from XTM service while retrieving job completion status.");
        }
        result = xtmResponse.getJobs().stream().collect(Collectors.toMap(job -> job.getJobDescriptor().getId(), this::mapXTMJobStatusToAEMTranslationStatus));
        return result;
    }

    private TranslationConstants.TranslationStatus mapXTMJobStatusToAEMTranslationStatus(XtmJobStatusResponseAPI jobResponse) {
        switch (jobResponse.getStatus()) {
            case ERROR: {
                return TranslationConstants.TranslationStatus.ERROR_UPDATE;
            }
            case FINISHED: {
                return TranslationConstants.TranslationStatus.TRANSLATED;
            }
            case IN_PROGRESS: {
                if (this.hasAnyJobStepStarted(jobResponse)) {
                    return TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS;
                }
                return TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION;
            }
        }
        return TranslationConstants.TranslationStatus.UNKNOWN_STATE;
    }

    private boolean hasAnyJobStepStarted(XtmJobStatusResponseAPI jobResponse) {
        boolean anyStepStarted = false;
        for (XtmStepStatusResponseAPI stepStatus : jobResponse.getSteps()) {
            if (stepStatus.getStatus().equals((Object)XtmSTEPCOMPLETIONSTATUS.NOT_STARTED)) continue;
            anyStepStarted = true;
            break;
        }
        return anyStepStarted;
    }
}

