/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.XtmObtainProjectEstimatesOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmObtainProjectEstimatesResponseAPI;
import com.xtm.aem.soap.wsdl.XtmProjectDescriptorAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmProjectDescriptor;
import java.util.HashMap;
import java.util.Map;

public class ObtainProjectEstimatesSoapAction
extends AbstractXtmServiceSoapAction<Map<String, String>>
implements XtmServiceAction<Map<String, String>> {
    private final LoginAPI loginAPI;
    private final XtmProjectDescriptorAPI projectDescriptor;
    private final XtmObtainProjectEstimatesOptionsAPI obtainProjectEstimatesOptions;

    public ObtainProjectEstimatesSoapAction(Long projectId, TranslationCloudConfig xtmCloudConfig) {
        this.cloudConfig = xtmCloudConfig;
        this.loginAPI = new Login(this.cloudConfig);
        this.projectDescriptor = new XtmProjectDescriptor(projectId);
        this.obtainProjectEstimatesOptions = null;
        this.proxyConfiguration = xtmCloudConfig.getProxyConfiguration();
    }

    @Override
    protected Map<String, String> run() throws Exception {
        HashMap<String, String> estimatesResult = new HashMap<String, String>();
        log.info("Requesting XTM Project Estimates");
        XtmObtainProjectEstimatesResponseAPI projectEstimatesResponse = this.xtmWebService.obtainProjectEstimates(this.loginAPI, this.projectDescriptor, this.obtainProjectEstimatesOptions);
        estimatesResult.put("Estimated delivery date", projectEstimatesResponse.getProjectEstimates().getDeliveryDate().toString());
        estimatesResult.put("Estimated price", projectEstimatesResponse.getProjectEstimates().getPrice().toPlainString());
        estimatesResult.put("Estimated tax price", projectEstimatesResponse.getProjectEstimates().getTaxPrice().toPlainString());
        estimatesResult.put("Currency", projectEstimatesResponse.getProjectEstimates().getCurrency().value());
        return estimatesResult;
    }
}

