/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.adobe.granite.translation.api.TranslationScope;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.ObtainPMProjectEditorLinkSoapAction;
import com.xtm.aem.soap.legacy.ObtainProjectEstimatesSoapAction;
import com.xtm.aem.soap.legacy.ObtainProjectMetricsSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.PmProjectEditorTabEnum;
import com.xtm.aem.soap.wsdlextensions.Login;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainProjectScopeSoapAction
extends AbstractXtmServiceSoapAction<TranslationScope>
implements XtmServiceAction<TranslationScope> {
    private static final Logger log = LoggerFactory.getLogger(ObtainProjectScopeSoapAction.class);
    private final LoginAPI loginAPI;
    private final Long projectId;

    public ObtainProjectScopeSoapAction(Long projectId, TranslationCloudConfig xtmCloudConfig) {
        this.cloudConfig = xtmCloudConfig;
        this.loginAPI = new Login(this.cloudConfig);
        this.projectId = projectId;
        this.proxyConfiguration = xtmCloudConfig.getProxyConfiguration();
    }

    @Override
    protected TranslationScope run() throws Exception {
        XtmTranslationScopeImpl xtmTranslationScope = new XtmTranslationScopeImpl();
        ObtainProjectEstimatesSoapAction estimatesAction = new ObtainProjectEstimatesSoapAction(this.projectId, this.cloudConfig);
        this.addConvertedEstimatesToTranslationScope(xtmTranslationScope, (Map)estimatesAction.runWithHandlers());
        ObtainProjectMetricsSoapAction metricsAction = new ObtainProjectMetricsSoapAction(this.projectId, this.cloudConfig);
        this.addConvertedXtmMetricsToTranslationScope(xtmTranslationScope, (Map)metricsAction.runWithHandlers());
        ArrayList<PmProjectEditorTabEnum> visibleTabs = new ArrayList<PmProjectEditorTabEnum>();
        visibleTabs.add(PmProjectEditorTabEnum.METRICS);
        ObtainPMProjectEditorLinkSoapAction findPMEditorLinkAction = new ObtainPMProjectEditorLinkSoapAction(this.projectId, visibleTabs, this.cloudConfig);
        xtmTranslationScope.addMetric("TranslationScope:DetailsLink", (String)findPMEditorLinkAction.runWithHandlers());
        return xtmTranslationScope;
    }

    private void addConvertedXtmMetricsToTranslationScope(XtmTranslationScopeImpl translationScope, Map<String, String> xtmMetrics) {
        translationScope.setWordCount(Integer.parseInt(xtmMetrics.get("TotalWords")));
        translationScope.addMetric("Total Word Count", xtmMetrics.get("TotalWords"));
        translationScope.addMetric("ICE Match", String.valueOf(Long.parseLong(xtmMetrics.get("ExactMatchWords"))));
        translationScope.addMetric("100% Match", String.valueOf(Long.parseLong(xtmMetrics.get("LeveragedTmWords"))));
        translationScope.addMetric("Repetition", xtmMetrics.get("LeveragedInheritedWords"));
        try {
            String fuzzyMatchC1Words = xtmMetrics.get("FuzzyMatchC1Words");
            String fuzzyMatchC2Words = xtmMetrics.get("FuzzyMatchC2Words");
            String fuzzyMatchC3Words = xtmMetrics.get("FuzzyMatchC3Words");
            if (null != fuzzyMatchC1Words && null != fuzzyMatchC2Words && null != fuzzyMatchC3Words) {
                translationScope.addMetric("99%-95% Match", fuzzyMatchC1Words);
                translationScope.addMetric("94-85% Match", fuzzyMatchC2Words);
                translationScope.addMetric("84-75% Match", fuzzyMatchC3Words);
            }
        }
        catch (NumberFormatException e) {
            log.error("Error parsing XTM fuzzyMatch values");
        }
        translationScope.addMetric("Machine Translation", xtmMetrics.get("MachineTranslationWords"));
    }

    private void addConvertedEstimatesToTranslationScope(XtmTranslationScopeImpl translationScope, Map<String, String> xtmEstimates) {
        translationScope.addEstimate("TranslationScope:CostEstimate", xtmEstimates.get("Currency") + " " + xtmEstimates.get("Estimated price"));
    }

    private class XtmTranslationScopeImpl
    implements TranslationScope {
        private Map<String, String> scopeItems = new LinkedHashMap<String, String>();
        private int wordCount = 0;
        private int imageCount;
        private int videoCount;

        public void addCostItem(Long id, String value) {
            this.scopeItems.put(id.toString(), value);
        }

        public void addEstimate(String key, String value) {
            this.scopeItems.put(key, value);
        }

        public void addMetric(String key, String value) {
            this.scopeItems.put(key, value);
        }

        public void addStatistic(String key, String value) {
            this.scopeItems.put(key, value);
        }

        public void addGenericScopeItem(String key, String value) {
            this.scopeItems.put(key, value);
        }

        public int getWordCount() {
            return this.wordCount;
        }

        public void setWordCount(int wordCount) {
            this.wordCount = wordCount;
        }

        public int getImageCount() {
            return this.imageCount;
        }

        public void setImageCount(int imageCount) {
            this.imageCount = imageCount;
        }

        public int getVideoCount() {
            return this.videoCount;
        }

        public void setVideoCount(int videoCount) {
            this.videoCount = videoCount;
        }

        public Map<String, String> getFinalScope() {
            return this.scopeItems;
        }
    }
}

