/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.adobe.granite.translation.api.TranslationConstants;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.XtmCheckProjectCompletionOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmCheckProjectCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmJobStatusResponseAPI;
import com.xtm.aem.soap.wsdl.XtmPROJECTCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdl.XtmProjectDescriptorAPI;
import com.xtm.aem.soap.wsdl.XtmSTEPCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdl.XtmStepStatusResponseAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmProjectDescriptor;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainProjectStatusSoapAction
extends AbstractXtmServiceSoapAction<TranslationConstants.TranslationStatus>
implements XtmServiceAction<TranslationConstants.TranslationStatus> {
    private static final Logger log = LoggerFactory.getLogger(ObtainProjectStatusSoapAction.class);
    private final LoginAPI loginAPI;
    private final XtmProjectDescriptorAPI projectDescriptor;
    private final XtmCheckProjectCompletionOptionsAPI checkProjectCompletionOptions;
    private Long projectId;

    public ObtainProjectStatusSoapAction(Long projectId, TranslationCloudConfig xtmCloudConfig) {
        this.cloudConfig = xtmCloudConfig;
        this.projectId = projectId;
        this.loginAPI = new Login(this.cloudConfig);
        this.projectDescriptor = new XtmProjectDescriptor(projectId);
        this.checkProjectCompletionOptions = null;
        this.proxyConfiguration = xtmCloudConfig.getProxyConfiguration();
    }

    @Override
    protected TranslationConstants.TranslationStatus run() throws Exception {
        log.info("Obtaining XTM Translation Status");
        XtmCheckProjectCompletionResponseAPI xtmResponse = this.xtmWebService.checkProjectCompletion(this.loginAPI, this.projectDescriptor, this.checkProjectCompletionOptions);
        if (null != xtmResponse) {
            TranslationConstants.TranslationStatus aemStatus;
            switch (xtmResponse.getProject().getActivity()) {
                case ARCHIVED: 
                case AUTO_ARCHIVED: {
                    log.debug("Project with Id: " + this.projectId + ", was archived in XTM.");
                    return TranslationConstants.TranslationStatus.ARCHIVE;
                }
                case CANCELLED: 
                case DELETED: {
                    log.debug("Project with Id: " + this.projectId + ", was cancelled or deleted in XTM.");
                    return TranslationConstants.TranslationStatus.CANCEL;
                }
                case INACTIVE: {
                    return TranslationConstants.TranslationStatus.UNKNOWN_STATE;
                }
            }
            XtmPROJECTCOMPLETIONSTATUS projectStatus = xtmResponse.getProject().getStatus();
            switch (projectStatus) {
                case FINISHED: {
                    aemStatus = TranslationConstants.TranslationStatus.TRANSLATED;
                    break;
                }
                case IN_PROGRESS: 
                case PARTIALLY_FINISHED: {
                    aemStatus = xtmResponse.getProject().getJobs().stream().map(XtmJobStatusResponseAPI::getSteps).flatMap(Collection::stream).map(XtmStepStatusResponseAPI::getStatus).allMatch(XtmSTEPCOMPLETIONSTATUS.NOT_STARTED::equals) ? TranslationConstants.TranslationStatus.SUBMITTED : TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS;
                    break;
                }
                default: {
                    aemStatus = TranslationConstants.TranslationStatus.UNKNOWN_STATE;
                }
            }
            log.debug("XTM project status: {}, converting to Translation Status: {}", (Object)projectStatus, (Object)aemStatus);
            return aemStatus;
        }
        throw new XtmConnectorException("Unexpected response while checking completion status in XTM.");
    }
}

