/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.XtmCustomerDetailsResponseAPI;
import com.xtm.aem.soap.wsdl.XtmFindCustomerAPI;
import com.xtm.aem.soap.wsdl.XtmFindCustomerOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmFindCustomerResponseAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import java.util.HashMap;
import java.util.Map;

public class RetrieveAllCustomersSoapAction
extends AbstractXtmServiceSoapAction<Map<String, String>>
implements XtmServiceAction<Map<String, String>> {
    private final LoginAPI loginAPI;
    private final XtmFindCustomerAPI customerFilter;
    private final XtmFindCustomerOptionsAPI customerOptions;

    public RetrieveAllCustomersSoapAction(TranslationCloudConfig xtmCloudConfig) {
        this.cloudConfig = xtmCloudConfig;
        this.loginAPI = new Login(this.cloudConfig);
        this.customerFilter = new XtmFindCustomerAPI();
        this.customerOptions = null;
        this.proxyConfiguration = xtmCloudConfig.getProxyConfiguration();
    }

    @Override
    protected Map<String, String> run() throws Exception {
        HashMap<String, String> customerResult = new HashMap<String, String>();
        log.info("Finding XTM Customers");
        XtmFindCustomerResponseAPI xtmResponse = this.xtmWebService.findCustomer(this.loginAPI, this.customerFilter, this.customerOptions);
        if (null == xtmResponse) {
            throw new XtmConnectorException("No response received from XTM when attempting to retrieve Customers.");
        }
        for (XtmCustomerDetailsResponseAPI customerDetails : xtmResponse.getCustomers()) {
            customerResult.put(customerDetails.getCustomer().getId().toString(), customerDetails.getCustomer().getName());
        }
        return this.sortByValueComparator(customerResult, true);
    }
}

