/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.XtmCustomerDescriptorAPI;
import com.xtm.aem.soap.wsdl.XtmFindTemplateAPI;
import com.xtm.aem.soap.wsdl.XtmFindTemplateOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmFindTemplateResponseAPI;
import com.xtm.aem.soap.wsdl.XtmTEMPLATESCOPEAPI;
import com.xtm.aem.soap.wsdl.XtmTemplateDetailsResponseAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmCustomerDescriptor;
import java.util.HashMap;
import java.util.Map;

public class RetrieveTemplatesSoapAction
extends AbstractXtmServiceSoapAction<Map<String, String>>
implements XtmServiceAction<Map<String, String>> {
    private final LoginAPI loginAPI;
    private final XtmCustomerDescriptorAPI customerDescriptor;
    private final XtmFindTemplateAPI templateFilter;
    private final XtmFindTemplateOptionsAPI findTemplateOptions;

    public RetrieveTemplatesSoapAction(Long customerId, TranslationCloudConfig xtmCloudConfig) {
        this.cloudConfig = xtmCloudConfig;
        this.loginAPI = new Login(this.cloudConfig);
        this.customerDescriptor = new XtmCustomerDescriptor(customerId);
        this.templateFilter = new XtmFindTemplateAPI();
        this.templateFilter.setScope(XtmTEMPLATESCOPEAPI.CUSTOMERS);
        this.templateFilter.getCustomers().add(this.customerDescriptor);
        this.findTemplateOptions = null;
        this.proxyConfiguration = xtmCloudConfig.getProxyConfiguration();
    }

    @Override
    protected Map<String, String> run() throws Exception {
        HashMap<String, String> templateResult = new HashMap<String, String>();
        log.info("Requesting XTM templates");
        XtmFindTemplateResponseAPI xtmResponse = this.xtmWebService.findTemplate(this.loginAPI, this.templateFilter, this.findTemplateOptions);
        if (null == xtmResponse) {
            throw new XtmConnectorException("No response received from XTM when attempting to retrieve Workflow Templates.");
        }
        for (XtmTemplateDetailsResponseAPI templateDetails : xtmResponse.getTemplates()) {
            templateResult.put(templateDetails.getTemplate().getId().toString(), templateDetails.getTemplate().getName());
        }
        return this.sortByValueComparator(templateResult, true);
    }
}

