/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy.jaxws;

import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.config.http.ConduitConfiguration;
import com.xtm.aem.soap.services.OsgiAwareClientFactory;
import com.xtm.aem.soap.services.logging.XtmLoggingInInterceptor;
import com.xtm.aem.soap.services.logging.XtmLoggingOutInterceptor;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JaxWsClientFactoryImpl {
    private static final Map<String, Object> FACTORY_PARAMS = ImmutableMap.of((Object)"mtom-enabled", (Object)Boolean.TRUE, (Object)"set-jaxb-validation-event-handler", (Object)"false");
    private static final Logger log = LoggerFactory.getLogger(JaxWsClientFactoryImpl.class);

    private JaxWsClientFactoryImpl() {
    }

    public static <T> T create(Class<T> parentClass, String portUrl, ProxyConfiguration proxyConfiguration) {
        return JaxWsClientFactoryImpl.create(parentClass, portUrl, null, null, proxyConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T create(Class<T> parentClass, String portUrl, String userName, String password, ProxyConfiguration proxyConfiguration) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BusFactory.class.getClassLoader());
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean(new OsgiAwareClientFactory());
            factory.getInInterceptors().add(new XtmLoggingInInterceptor());
            factory.getOutInterceptors().add(new XtmLoggingOutInterceptor());
            factory.setProperties(FACTORY_PARAMS);
            factory.setServiceClass(parentClass);
            factory.setAddress(portUrl);
            factory.setUsername(userName);
            factory.setPassword(password);
            ConduitConfiguration conduitConfig = JaxWsClientFactoryImpl.getConduitConfig();
            Object wsPort = factory.create();
            Client client = ClientProxy.getClient(wsPort);
            HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
            httpConduit.getClient().setConnectionTimeout(conduitConfig.getConnectionTimeout());
            httpConduit.getClient().setReceiveTimeout(conduitConfig.getReceiveTimeout());
            if (proxyConfiguration != null && proxyConfiguration.isEnabled()) {
                JaxWsClientFactoryImpl.setProxyConfiguration(proxyConfiguration, httpConduit);
            }
            Object object = wsPort;
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static ConduitConfiguration getConduitConfig() {
        BundleContext context = FrameworkUtil.getBundle(ConduitConfiguration.class).getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(ConduitConfiguration.class);
        ConduitConfiguration config = (ConduitConfiguration)context.getService(serviceReference);
        context.ungetService(serviceReference);
        return config;
    }

    private static void setProxyConfiguration(ProxyConfiguration proxyConfiguration, HTTPConduit httpConduit) {
        httpConduit.getClient().setProxyServer(proxyConfiguration.getHostname());
        httpConduit.getClient().setProxyServerPort(proxyConfiguration.getPort());
        if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername())) {
            httpConduit.getProxyAuthorization().setUserName(proxyConfiguration.getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
            httpConduit.getProxyAuthorization().setPassword(proxyConfiguration.getPassword());
        }
    }
}

