/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.soap.legacy.ObtainJobStatusSoapAction;
import com.xtm.aem.soap.legacy.RejectJobSoapAction;
import java.util.Map;

public class JobStatusUpdater {
    private final TranslationCloudConfig cloudConfiguration;
    private final XtmCanceller canceller;

    public JobStatusUpdater(TranslationCloudConfig cloudConfiguration, XtmCanceller canceller) {
        this.cloudConfiguration = cloudConfiguration;
        this.canceller = canceller;
    }

    public TranslationConstants.TranslationStatus updateTranslationStatus(TranslationConstants.TranslationStatus translationStatus, AemTranslationObject aemTranslationObject) throws TranslationException {
        switch (translationStatus) {
            case CANCEL: {
                return this.cancel(aemTranslationObject);
            }
            case REJECTED: {
                return this.reject(aemTranslationObject);
            }
        }
        return this.update(aemTranslationObject);
    }

    private TranslationConstants.TranslationStatus cancel(AemTranslationObject aemTranslationObject) throws TranslationException {
        this.canceller.cancel(aemTranslationObject);
        return TranslationConstants.TranslationStatus.CANCEL;
    }

    private TranslationConstants.TranslationStatus update(AemTranslationObject aemTranslationObject) throws TranslationException {
        ObtainJobStatusSoapAction action = new ObtainJobStatusSoapAction(Sets.newHashSet((Object[])new Long[]{aemTranslationObject.getXtmJobId()}), this.cloudConfiguration);
        return (TranslationConstants.TranslationStatus)((Map)action.runWithHandlers()).get(aemTranslationObject.getXtmJobId());
    }

    private TranslationConstants.TranslationStatus reject(AemTranslationObject aemTranslationObject) throws TranslationException {
        RejectJobSoapAction action = new RejectJobSoapAction(Lists.newArrayList((Object[])new Long[]{aemTranslationObject.getXtmJobId()}), this.cloudConfiguration);
        Map result = (Map)action.runWithHandlers();
        return (TranslationConstants.TranslationStatus)result.entrySet().iterator().next().getValue();
    }
}

