/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.translation.connector.xtmforaem.core.models.ComplexAemTranslationProjectManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"resource.change.types=REMOVED", "resource.paths=/content/projects"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class ProjectDeletionListener
implements ResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectDeletionListener.class);
    @Reference
    private ResourceResolverProvider provider;
    @Reference
    private XtmCanceller canceller;

    public void onChange(List<ResourceChange> changes) {
        try (ResourceResolver resourceResolver = this.provider.getXtmResourceResolver();){
            for (ResourceChange change : changes) {
                String changePath = change.getPath();
                if (this.isTranslationJob(changePath)) {
                    this.handleTranslationJobDeletion(resourceResolver, changePath);
                    continue;
                }
                AemTranslationProject atp = ComplexAemTranslationProjectManager.getExisting(resourceResolver, changePath);
                if (atp == null) continue;
                this.handleProjectDeletion(resourceResolver, atp);
            }
            if (resourceResolver.hasChanges()) {
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            throw new IllegalStateException("Could not obtain resource resolver", e);
        }
        catch (TranslationException | PersistenceException e) {
            log.error("Could not archive projects in XTM");
        }
    }

    private void handleTranslationJobDeletion(ResourceResolver resourceResolver, String rawJobPath) throws TranslationException, PersistenceException {
        AemTranslationProject atp = this.getAemTranslationProject(resourceResolver, rawJobPath);
        if (atp == null) {
            return;
        }
        List<AemTranslationJob> atjToDelete = atp.getTranslationJobs().stream().filter(atj -> atj.getRawJob() == null).collect(Collectors.toList());
        for (AemTranslationJob job : atjToDelete) {
            this.canceller.cancel(job);
        }
        String[] newIds = (String[])atp.getTranslationJobs().stream().filter(atj -> atj.getRawJob() != null).map(AemTranslationJob::getAemJobId).toArray(String[]::new);
        this.deleteJobResources(atjToDelete, resourceResolver);
        atp.setAemTranslationJobIds(newIds);
    }

    private AemTranslationProject getAemTranslationProject(ResourceResolver resourceResolver, String rawJobPath) {
        String[] parts = rawJobPath.split("/");
        String projectPath = Arrays.stream(parts).limit(parts.length - 4).collect(Collectors.joining("/"));
        Resource rawProjectResource = resourceResolver.getResource(projectPath);
        if (rawProjectResource == null) {
            return null;
        }
        RawTranslationProject rawTranslationProject = (RawTranslationProject)rawProjectResource.adaptTo(RawTranslationProject.class);
        return ComplexAemTranslationProjectManager.getExisting(resourceResolver, rawTranslationProject);
    }

    private void handleProjectDeletion(ResourceResolver resourceResolver, AemTranslationProject atp) throws TranslationException, PersistenceException {
        this.canceller.cancel(atp);
        resourceResolver.delete(Objects.requireNonNull(resourceResolver.getResource(atp.getPath())));
        this.deleteJobResources(atp.getTranslationJobs(), resourceResolver);
    }

    private void deleteJobResources(Collection<AemTranslationJob> jobs, ResourceResolver resourceResolver) throws PersistenceException {
        List jobResources = jobs.stream().map(AemTranslationJob::getPath).map(arg_0 -> ((ResourceResolver)resourceResolver).getResource(arg_0)).collect(Collectors.toList());
        for (Resource jobResource : jobResources) {
            resourceResolver.delete(jobResource);
        }
    }

    private boolean isTranslationJob(String changePath) {
        String lastPathPart = StringUtils.substringAfterLast((String)changePath, (String)"/");
        return StringUtils.startsWith((CharSequence)lastPathPart, (CharSequence)"translationjob");
    }
}

